/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import io.particle.android.sdk.accountsetup.CreateAccountActivity;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.persistance.SensitiveDataStorage;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;

public class NextActivitySelector {
    private static final TLog log = TLog.get(NextActivitySelector.class);
    private final ParticleCloud cloud;
    private final SensitiveDataStorage credStorage;
    private final Class<? extends Activity> mainActivityClass;

    public static Intent getNextActivityIntent(Context ctx, ParticleCloud particleCloud, SensitiveDataStorage credStorage) {
        NextActivitySelector selector = new NextActivitySelector(particleCloud, credStorage, ParticleDeviceSetupLibrary.getInstance().getMainActivityClass());
        Class<? extends Activity> nextActivity = selector.buildIntentForNextActivity();
        return new Intent(ctx, nextActivity);
    }

    private NextActivitySelector(ParticleCloud cloud, SensitiveDataStorage credStorage, Class<? extends Activity> mainActivityClass) {
        this.cloud = cloud;
        this.credStorage = credStorage;
        this.mainActivityClass = mainActivityClass;
    }

    Class<? extends Activity> buildIntentForNextActivity() {
        if (!this.hasUserBeenLoggedInBefore()) {
            log.d("User has not been logged in before");
            return CreateAccountActivity.class;
        }
        if (!this.isOAuthTokenPresent()) {
            log.d("No auth token present");
            return LoginActivity.class;
        }
        log.d("Returning default activity");
        return this.mainActivityClass;
    }

    boolean hasUserBeenLoggedInBefore() {
        return Py.any((Object[])new Object[]{this.credStorage.getUser(), this.credStorage.getToken()});
    }

    boolean isOAuthTokenPresent() {
        return Py.truthy((Object)this.cloud.getAccessToken());
    }
}

