/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.Loader;
import android.view.View;
import android.widget.CheckBox;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.InterfaceBindingSocketFactory;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.loaders.ScanApCommandLoader;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.devicesetup.ui.ConnectingActivity;
import io.particle.android.sdk.devicesetup.ui.PasswordEntryActivity;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.WiFi;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Set;

public class ManualNetworkEntryActivity
extends BaseActivity
implements LoaderManager.LoaderCallbacks<Set<ScanAPCommandResult>> {
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_manual_network_entry);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
    }

    public void onConnectClicked(View view) {
        String ssid = Ui.getText((FragmentActivity)this, R.id.network_name, true);
        ScanApCommand.Scan scan = new ScanApCommand.Scan(ssid, WifiSecurity.WPA2_AES_PSK.asInt(), 0);
        CheckBox requiresPassword = (CheckBox)Ui.findView((FragmentActivity)this, R.id.network_requires_password);
        if (requiresPassword.isChecked()) {
            this.startActivity(PasswordEntryActivity.buildIntent((Context)this, scan));
        } else {
            String softApSSID = WiFi.getCurrentlyConnectedSSID((Context)this);
            this.startActivity(ConnectingActivity.buildIntent((Context)this, softApSSID, scan));
        }
    }

    public void onCancelClicked(View view) {
        this.finish();
    }

    public Loader<Set<ScanAPCommandResult>> onCreateLoader(int id2, Bundle args) {
        CommandClient client = CommandClient.newClientUsingDefaultSocketAddress();
        String softApSSID = WiFi.getCurrentlyConnectedSSID((Context)this);
        InterfaceBindingSocketFactory socketFactory = new InterfaceBindingSocketFactory((Context)this, softApSSID);
        return new ScanApCommandLoader((Context)this, client, socketFactory);
    }

    public void onLoadFinished(Loader<Set<ScanAPCommandResult>> loader, Set<ScanAPCommandResult> data) {
    }

    public void onLoaderReset(Loader<Set<ScanAPCommandResult>> loader) {
    }
}

