/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.content.Context;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ConfigureApCommand;
import io.particle.android.sdk.devicesetup.commands.InterfaceBindingSocketFactory;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.commands.data.WifiSecurity;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.utils.Crypto;
import java.io.IOException;
import java.security.PublicKey;

public class ConfigureAPStep
extends SetupStep {
    private final CommandClient commandClient;
    private final ScanApCommand.Scan networkToConnectTo;
    private final String networkSecretPlaintext;
    private final PublicKey publicKey;
    private final Context ctx;
    private volatile boolean commandSent = false;

    public ConfigureAPStep(StepConfig stepConfig, CommandClient commandClient, ScanApCommand.Scan networkToConnectTo, String networkSecretPlaintext, PublicKey publicKey, Context ctx) {
        super(stepConfig);
        this.commandClient = commandClient;
        this.networkToConnectTo = networkToConnectTo;
        this.networkSecretPlaintext = networkSecretPlaintext;
        this.publicKey = publicKey;
        this.ctx = ctx;
    }

    @Override
    protected void onRunStep() throws SetupStepException {
        WifiSecurity wifiSecurity = WifiSecurity.fromInteger(this.networkToConnectTo.wifiSecurityType);
        ConfigureApCommand.Builder builder = ConfigureApCommand.newBuilder().setSsid(this.networkToConnectTo.ssid).setSecurityType(wifiSecurity).setChannel(this.networkToConnectTo.channel).setIdx(0);
        if (wifiSecurity != WifiSecurity.OPEN) {
            try {
                builder.setEncryptedPasswordHex(Crypto.encryptAndEncodeToHex(this.networkSecretPlaintext, this.publicKey));
            }
            catch (Crypto.CryptoException e) {
                throw new RuntimeException("Error encrypting network credentials", e);
            }
        }
        ConfigureApCommand command = builder.build();
        try {
            ConfigureApCommand.Response response = this.commandClient.sendCommandAndReturnResponse(command, ConfigureApCommand.Response.class, new InterfaceBindingSocketFactory(this.ctx));
            if (!response.isOk()) {
                throw new SetupStepException("Error response code " + response.responseCode + " while configuring device");
            }
            this.log.d("Configure AP command returned: " + response.responseCode);
            this.commandSent = true;
        }
        catch (IOException e) {
            throw new SetupStepException(e);
        }
    }

    @Override
    public boolean isStepFulfilled() {
        return this.commandSent;
    }
}

