/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.commands;

import android.support.annotation.NonNull;
import com.google.gson.Gson;
import io.particle.android.sdk.devicesetup.commands.CeciNestPasUnSocketFactory;
import io.particle.android.sdk.devicesetup.commands.Command;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import org.apache.commons.lang3.StringEscapeUtils;

public class CommandClient {
    public static final int DEFAULT_TIMEOUT_SECONDS = 10;
    private static final TLog log = TLog.get(CommandClient.class);
    private static final Gson gson = new Gson();
    private final InetSocketAddress deviceAddress;

    public static CommandClient newClient(@NonNull InetSocketAddress socketAddress) {
        return new CommandClient(socketAddress);
    }

    public static CommandClient newClientUsingDefaultSocketAddress() {
        return CommandClient.newClient(new InetSocketAddress("192.168.0.1", 5609));
    }

    private CommandClient(InetSocketAddress deviceAddress) {
        this.deviceAddress = deviceAddress;
    }

    public void sendCommand(Command command, CeciNestPasUnSocketFactory socketFactory) throws IOException {
        this.sendAndMaybeReceive(command, Void.class, socketFactory);
    }

    public <T> T sendCommandAndReturnResponse(Command command, Class<T> responseType, CeciNestPasUnSocketFactory socketFactory) throws IOException {
        return this.sendAndMaybeReceive(command, responseType, socketFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T sendAndMaybeReceive(Command command, Class<T> responseType, CeciNestPasUnSocketFactory socketFactory) throws IOException {
        Socket socket;
        BufferedSink buffer;
        block3: {
            T t;
            log.i("Preparing to send command '" + command.getCommandName() + "'");
            String commandData = this.buildCommandData(command);
            buffer = null;
            try {
                int timeoutMillis = 10000;
                socket = socketFactory.buildSocket(timeoutMillis);
                socket.connect(this.deviceAddress, timeoutMillis);
                buffer = this.wrapSocket(socket, 10);
                log.d("Writing command data");
                buffer.writeUtf8(commandData);
                buffer.flush();
                if (!responseType.equals(Void.class)) break block3;
                log.d("Done.");
                t = null;
            }
            catch (Throwable throwable) {
                EZ.closeThisThingOrMaybeDont(buffer);
                throw throwable;
            }
            EZ.closeThisThingOrMaybeDont((Closeable)buffer);
            return t;
        }
        T t = this.readResponse(socket, responseType, 10);
        EZ.closeThisThingOrMaybeDont((Closeable)buffer);
        return t;
    }

    private BufferedSink wrapSocket(Socket socket, int timeoutValueInSeconds) throws IOException {
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)socket));
        sink.timeout().timeout((long)timeoutValueInSeconds, TimeUnit.SECONDS);
        return sink;
    }

    private String buildCommandData(Command command) {
        StringBuilder commandData = new StringBuilder().append(command.getCommandName()).append("\n");
        String commandArgs = command.argsAsJsonString(gson);
        if (Py.truthy((Object)commandArgs)) {
            commandData.append(commandArgs.length());
            commandData.append("\n\n");
            commandData.append(commandArgs);
        } else {
            commandData.append("0\n\n");
        }
        String built = commandData.toString();
        log.i("*** BUILT COMMAND DATA: '" + StringEscapeUtils.escapeJava((String)built) + "'");
        return built;
    }

    private <T> T readResponse(Socket socket, Class<T> responseType, int timeoutValueInSeconds) throws IOException {
        String line;
        BufferedSource buffer = Okio.buffer((Source)Okio.source((Socket)socket));
        buffer.timeout().timeout((long)timeoutValueInSeconds, TimeUnit.SECONDS);
        log.d("Reading response data...");
        while (Py.truthy((Object)(line = buffer.readUtf8LineStrict()))) {
        }
        String responseData = buffer.readUtf8();
        log.d("Command response (raw): " + StringEscapeUtils.escapeJava((String)responseData));
        Object tee = gson.fromJson(responseData, responseType);
        log.d("Command response: " + tee);
        EZ.closeThisThingOrMaybeDont((Closeable)buffer);
        return (T)tee;
    }
}

