/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class WiFi {
    private static final TLog log = TLog.get(WiFi.class);
    public static Predicate<ScanResult> is24Ghz = new Predicate<ScanResult>(){

        public boolean apply(ScanResult input) {
            return input.frequency > 2300 && input.frequency < 2500;
        }
    };
    public static Predicate<ScanResult> isWifiNameTruthy = new Predicate<ScanResult>(){

        public boolean apply(ScanResult input) {
            return Py.truthy((Object)input.SSID);
        }
    };

    public static void reenableNetwork(String ssid, Context ctx) {
        WifiManager wifiManager = WiFi.getWifiManager(ctx);
        int networkId = WiFi.getConfiguredNetworkId(ssid, ctx);
        if (networkId != -1) {
            log.d("Reenabling network configuration for:" + ssid);
            wifiManager.enableNetwork(networkId, false);
        } else {
            log.d("No network found for SSID " + ssid);
        }
    }

    public static void removeNetwork(String ssid, Context ctx) {
        WifiManager wifiManager = WiFi.getWifiManager(ctx);
        int networkId = WiFi.getConfiguredNetworkId(ssid, ctx);
        if (networkId != -1) {
            log.d("Removing network configuration for:" + ssid);
            wifiManager.removeNetwork(networkId);
        } else {
            log.d("No network found for SSID " + ssid);
        }
    }

    public static String getCurrentlyConnectedSSID(Context ctx) {
        WifiManager wifiManager = WiFi.getWifiManager(ctx);
        WifiInfo connectionInfo = wifiManager.getConnectionInfo();
        if (connectionInfo == null) {
            log.d("getCurrentlyConnectedSSID(): WifiManager.getConnectionInfo() returned null");
            return null;
        }
        String ssid = WiFi.deQuotifySsid(connectionInfo.getSSID());
        log.d("Currently connected to: " + ssid + ", supplicant state: " + connectionInfo.getSupplicantState());
        return ssid;
    }

    public static String enQuotifySsid(String SSID) {
        Preconditions.checkNotNull((Object)SSID, (Object)"'SSID' cannot be null!");
        String quoteMark = "\"";
        if (!SSID.startsWith("\"") && !SSID.endsWith("\"")) {
            SSID = "\"" + SSID + "\"";
        }
        return SSID;
    }

    public static String deQuotifySsid(String SSID) {
        if (SSID == null) {
            return null;
        }
        String quoteMark = "\"";
        SSID = StringUtils.removeStart((String)SSID, (String)quoteMark);
        SSID = StringUtils.removeEnd((String)SSID, (String)quoteMark);
        return SSID;
    }

    public static int getConfiguredNetworkId(String SSID, Context ctx) {
        WifiManager wifiManager = WiFi.getWifiManager(ctx);
        List configuredNetworks = wifiManager.getConfiguredNetworks();
        if (configuredNetworks != null) {
            for (WifiConfiguration config : configuredNetworks) {
                if (!SSID.equalsIgnoreCase(config.SSID)) continue;
                return config.networkId;
            }
        }
        return -1;
    }

    private static WifiManager getWifiManager(Context ctx) {
        return (WifiManager)ctx.getSystemService("wifi");
    }
}

