/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WiFi;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SoftAPConfigRemover {
    private static final TLog log = TLog.get(SoftAPConfigRemover.class);
    private static final String PREFS_SOFT_AP_NETWORK_REMOVER = "PREFS_SOFT_AP_NETWORK_REMOVER";
    private static final String KEY_SOFT_AP_SSIDS = "KEY_SOFT_AP_SSIDS";
    private static final String KEY_DISABLED_WIFI_SSIDS = "KEY_DISABLED_WIFI_SSIDS";
    private final Context ctx;
    private final SharedPreferences prefs;

    public SoftAPConfigRemover(Context ctx) {
        this.ctx = ctx.getApplicationContext();
        this.prefs = ctx.getSharedPreferences(PREFS_SOFT_AP_NETWORK_REMOVER, 0);
    }

    public void onSoftApConfigured(String newSsid) {
        Py.PySet ssids = Py.set(this.loadSSIDStringSetWithKey(KEY_SOFT_AP_SSIDS));
        ssids.add(newSsid);
        this.saveSSIDsWithKey(KEY_SOFT_AP_SSIDS, (Set<String>)ssids);
    }

    public void removeAllSoftApConfigs() {
        for (String ssid : this.loadSSIDStringSetWithKey(KEY_SOFT_AP_SSIDS)) {
            WiFi.removeNetwork(ssid, this.ctx);
        }
        this.saveSSIDsWithKey(KEY_SOFT_AP_SSIDS, new HashSet<String>());
    }

    public void onWifiNetworkDisabled(String ssid) {
        log.v("onWifiNetworkDisabled() " + ssid);
        Py.PySet ssids = Py.set(this.loadSSIDStringSetWithKey(KEY_DISABLED_WIFI_SSIDS));
        ssids.add(ssid);
        this.saveSSIDsWithKey(KEY_DISABLED_WIFI_SSIDS, (Set<String>)ssids);
    }

    public void reenableWifiNetworks() {
        log.v("reenableWifiNetworks()");
        for (String ssid : this.loadSSIDStringSetWithKey(KEY_DISABLED_WIFI_SSIDS)) {
            WiFi.reenableNetwork(ssid, this.ctx);
        }
        this.saveSSIDsWithKey(KEY_DISABLED_WIFI_SSIDS, new HashSet<String>());
    }

    private Set<String> loadSSIDStringSetWithKey(String key) {
        log.v("loadSSIDStringSetWithKey(" + key + ")");
        Object ssids = Py.set((Object[])new String[0]);
        ssids = this.prefs.getStringSet(key, (Set)ssids);
        log.v("Loaded saved SSIDS: " + ssids);
        Py.PySet diffQuotes = Py.set((Object[])new String[0]);
        Iterator iterator = ssids.iterator();
        while (iterator.hasNext()) {
            String ssid = (String)iterator.next();
            diffQuotes.add(WiFi.enQuotifySsid(ssid));
            diffQuotes.add(WiFi.deQuotifySsid(ssid));
        }
        ssids.addAll(diffQuotes);
        log.v("Returning SSIDS: " + ssids);
        return ssids;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private void saveSSIDsWithKey(String key, Set<String> ssids) {
        log.v("saveSSIDsWithKey() " + key + ", " + ssids);
        this.prefs.edit().putStringSet(key, ssids).commit();
    }
}

