/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.content.Context;
import android.net.wifi.WifiManager;
import com.google.common.base.Preconditions;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.WiFi;

public class WaitForDisconnectionFromDeviceStep
extends SetupStep {
    private final Context ctx;
    private final String softApName;
    private final WifiManager wifiManager;
    private boolean wasDisconnected = false;

    public WaitForDisconnectionFromDeviceStep(StepConfig stepConfig, String softApSSID, Context ctx) {
        super(stepConfig);
        Preconditions.checkNotNull((Object)softApSSID, (Object)"softApSSID cannot be null.");
        this.ctx = ctx;
        this.softApName = softApSSID;
        this.wifiManager = (WifiManager)ctx.getSystemService("wifi");
    }

    @Override
    public boolean isStepFulfilled() {
        return this.wasDisconnected;
    }

    @Override
    protected void onRunStep() throws SetupStepException, SetupProcessException {
        for (int i = 0; i <= 5; ++i) {
            if (!this.isConnectedToSoftAp()) {
                EZ.threadSleep((long)1000L);
                this.wasDisconnected = true;
                if (EZ.isUsingOlderWifiStack()) {
                    this.reenablePreviousWifi();
                }
                return;
            }
            EZ.threadSleep((long)200L);
        }
        throw new SetupStepException("Not disconnected from soft AP");
    }

    private void reenablePreviousWifi() {
        String prevSSID = DeviceSetupState.previouslyConnectedWifiNetwork;
        for (String ssid : Py.list((Object[])new String[]{prevSSID, WiFi.enQuotifySsid(prevSSID)})) {
            int netId = WiFi.getConfiguredNetworkId(ssid, this.ctx);
            this.log.d("Found ID " + netId + " for network " + ssid);
            if (netId == -1) continue;
            this.wifiManager.enableNetwork(netId, false);
        }
        this.wifiManager.reassociate();
    }

    private boolean isConnectedToSoftAp() {
        String currentlyConnectedSSID = WiFi.getCurrentlyConnectedSSID(this.ctx);
        this.log.d("Currently connected SSID: " + currentlyConnectedSSID);
        return this.softApName.equalsIgnoreCase(currentlyConnectedSSID);
    }
}

