/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.content.Context;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.utils.EZ;

public class EnsureSoftApNotVisible
extends SetupStep {
    private final WifiManager wifiManager;
    private final String softApName;
    private final Predicate<String> matchesSoftApSSID;
    private boolean wasFulfilledOnce = false;
    private static final Function<ScanResult, String> toSSID = new Function<ScanResult, String>(){

        public String apply(ScanResult input) {
            return input == null ? null : input.SSID;
        }
    };

    public EnsureSoftApNotVisible(StepConfig stepConfig, String softApSSID, Context ctx) {
        super(stepConfig);
        Preconditions.checkNotNull((Object)softApSSID, (Object)"softApSSID cannot be null.");
        this.wifiManager = (WifiManager)ctx.getSystemService("wifi");
        this.softApName = softApSSID;
        this.matchesSoftApSSID = new Predicate<String>(){

            public boolean apply(String input) {
                return EnsureSoftApNotVisible.this.softApName.equalsIgnoreCase(input);
            }
        };
    }

    @Override
    public boolean isStepFulfilled() {
        return this.wasFulfilledOnce && !this.isSoftApVisible();
    }

    @Override
    protected void onRunStep() throws SetupStepException, SetupProcessException {
        if (!this.wasFulfilledOnce) {
            this.onStepNeverYetFulfilled();
        } else {
            this.onStepPreviouslyFulfilled();
        }
    }

    private void onStepNeverYetFulfilled() throws SetupStepException {
        for (int i = 0; i < 16; ++i) {
            if (!this.isSoftApVisible()) {
                this.wasFulfilledOnce = true;
                return;
            }
            if (i % 6 == 0) {
                this.wifiManager.startScan();
            }
            EZ.threadSleep((long)250L);
        }
        throw new SetupStepException("Wi-Fi credentials appear to be incorrect or an error has occurred");
    }

    private void onStepPreviouslyFulfilled() throws SetupProcessException {
        if (this.isSoftApVisible()) {
            throw new SetupProcessException("Soft AP visible again; Wi-Fi credentials may be incorrect", this);
        }
    }

    private boolean isSoftApVisible() {
        ImmutableList scansPlusConnectedSsid = FluentIterable.from((Iterable)this.wifiManager.getScanResults()).transform(toSSID).toList();
        this.log.d("scansPlusConnectedSsid: " + scansPlusConnectedSsid);
        this.log.d("Soft AP we're looking for: " + this.softApName);
        Optional matchingSSID = FluentIterable.from((Iterable)this.wifiManager.getScanResults()).transform(toSSID).firstMatch(this.matchesSoftApSSID);
        this.log.d("Matching SSID?: " + matchingSSID);
        return matchingSSID.isPresent();
    }
}

