/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import java.util.List;

public class CheckIfDeviceClaimedStep
extends SetupStep {
    private final ParticleCloud sparkCloud;
    private final String deviceBeingConfiguredId;
    private boolean needToClaimDevice;

    public CheckIfDeviceClaimedStep(StepConfig stepConfig, ParticleCloud sparkCloud, String deviceBeingConfiguredId, boolean needToClaimDevice) {
        super(stepConfig);
        this.sparkCloud = sparkCloud;
        this.deviceBeingConfiguredId = deviceBeingConfiguredId;
        this.needToClaimDevice = needToClaimDevice;
    }

    @Override
    protected void onRunStep() throws SetupStepException {
        List devices;
        try {
            devices = this.sparkCloud.getDevices();
        }
        catch (ParticleCloudException e) {
            throw new SetupStepException(e);
        }
        this.log.d("Got devices back from the cloud...");
        for (ParticleDevice device : devices) {
            if (!this.deviceBeingConfiguredId.equalsIgnoreCase(device.getID())) continue;
            this.log.d("Success, device " + device.getID() + " claimed!");
            this.needToClaimDevice = false;
            return;
        }
        throw new SetupStepException("Device " + this.deviceBeingConfiguredId + " still not claimed.");
    }

    @Override
    public boolean isStepFulfilled() {
        return !this.needToClaimDevice;
    }
}

