/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.model;

import android.net.wifi.ScanResult;
import io.particle.android.sdk.devicesetup.model.WifiNetwork;
import io.particle.android.sdk.utils.Py;
import java.util.Set;

public class ScanResultNetwork
implements WifiNetwork {
    private static final Set<String> wifiSecurityTypes = Py.set((Object[])new String[]{"WEP", "PSK", "EAP"});
    public final ScanResult scanResult;

    public ScanResultNetwork(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    @Override
    public String getSsid() {
        return this.scanResult.SSID;
    }

    @Override
    public boolean isSecured() {
        for (String securityType : wifiSecurityTypes) {
            if (!this.scanResult.capabilities.contains(securityType)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanResultNetwork that = (ScanResultNetwork)o;
        return !(this.getSsid() != null ? !this.getSsid().equals(that.getSsid()) : that.getSsid() != null);
    }

    public int hashCode() {
        return this.getSsid() != null ? this.getSsid().hashCode() : 0;
    }
}

