/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import com.google.common.base.Preconditions;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.devicesetup.ui.GetReadyActivity;

public class ParticleDeviceSetupLibrary {
    private static ParticleDeviceSetupLibrary instance;
    private final Class<? extends Activity> mainActivity;

    public static void startDeviceSetup(Context ctx) {
        ctx.startActivity(new Intent(ctx, GetReadyActivity.class));
    }

    public static void init(Context ctx, Class<? extends Activity> mainActivity) {
        if (instance == null) {
            ParticleCloudSDK.init((Context)ctx);
            instance = new ParticleDeviceSetupLibrary(mainActivity);
        }
    }

    public static ParticleDeviceSetupLibrary getInstance() {
        Preconditions.checkNotNull((Object)instance, (Object)"Library instance is null: did you call ParticleDeviceSetupLibrary.init()?");
        return instance;
    }

    public Class<? extends Activity> getMainActivityClass() {
        return this.mainActivity;
    }

    private ParticleDeviceSetupLibrary(Class<? extends Activity> mainActivity) {
        this.mainActivity = mainActivity;
    }

    public static abstract class DeviceSetupCompleteReceiver
    extends BroadcastReceiver {
        public abstract void onSetupSuccess(@NonNull String var1);

        public abstract void onSetupFailure();

        public void register(Context ctx) {
            LocalBroadcastManager.getInstance((Context)ctx).registerReceiver((BroadcastReceiver)this, this.buildIntentFilter());
        }

        public void unregister(Context ctx) {
            LocalBroadcastManager.getInstance((Context)ctx).unregisterReceiver((BroadcastReceiver)this);
        }

        public void onReceive(Context context, Intent intent) {
            boolean success = intent.getBooleanExtra("EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL", false);
            String deviceId = intent.getStringExtra("EXTRA_CONFIGURED_DEVICE_ID");
            if (success && deviceId != null) {
                this.onSetupSuccess(deviceId);
            } else {
                this.onSetupFailure();
            }
        }

        public IntentFilter buildIntentFilter() {
            return new IntentFilter("ACTION_DEVICE_SETUP_COMPLETE");
        }
    }

    public static interface DeviceSetupCompleteContract {
        public static final String ACTION_DEVICE_SETUP_COMPLETE = "ACTION_DEVICE_SETUP_COMPLETE";
        public static final String EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL = "EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL";
        public static final String EXTRA_CONFIGURED_DEVICE_ID = "EXTRA_CONFIGURED_DEVICE_ID";
    }
}

