/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.widget.ImageView;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.ui.NextActivitySelector;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;

public class SuccessActivity
extends BaseActivity {
    public static final String EXTRA_RESULT_CODE = "EXTRA_RESULT_CODE";
    public static final int RESULT_SUCCESS = 1;
    public static final int RESULT_SUCCESS_UNKNOWN_OWNERSHIP = 2;
    public static final int RESULT_FAILURE_CLAIMING = 3;
    public static final int RESULT_FAILURE_CONFIGURE = 4;
    public static final int RESULT_FAILURE_NO_DISCONNECT = 5;
    public static final int RESULT_FAILURE_LOST_CONNECTION_TO_DEVICE = 6;
    private static final SparseArray<Pair<Integer, Integer>> resultCodesToStringIds = new SparseArray(6);
    private ParticleCloud particleCloud;

    public static Intent buildIntent(Context ctx, int resultCode) {
        return new Intent(ctx, SuccessActivity.class).putExtra(EXTRA_RESULT_CODE, resultCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_success);
        this.particleCloud = ParticleCloud.get((Context)this);
        int resultCode = this.getIntent().getIntExtra(EXTRA_RESULT_CODE, -1);
        final boolean isSuccess = Py.list((Object[])new Integer[]{1, 2}).contains(resultCode);
        if (!isSuccess) {
            ImageView image = (ImageView)Ui.findView((FragmentActivity)this, R.id.result_image);
            image.setImageResource(R.drawable.fail);
        }
        Pair<? extends CharSequence, CharSequence> resultStrings = this.buildUiStringPair(resultCode);
        Ui.setText((FragmentActivity)this, R.id.result_summary, (CharSequence)resultStrings.first);
        Ui.setText((FragmentActivity)this, R.id.result_details, (CharSequence)resultStrings.second);
        Ui.findView((FragmentActivity)this, R.id.action_done).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = NextActivitySelector.getNextActivityIntent(v.getContext(), SuccessActivity.this.particleCloud, SDKGlobals.getSensitiveDataStorage(), SDKGlobals.getAppDataStorage());
                intent.setFlags(872448000);
                SuccessActivity.this.startActivity(intent);
                Intent result = new Intent("ACTION_DEVICE_SETUP_COMPLETE").putExtra("EXTRA_DEVICE_SETUP_WAS_SUCCESSFUL", isSuccess);
                if (isSuccess) {
                    result.putExtra("EXTRA_CONFIGURED_DEVICE_ID", DeviceSetupState.deviceToBeSetUpId);
                }
                LocalBroadcastManager.getInstance((Context)v.getContext()).sendBroadcast(result);
                SuccessActivity.this.finish();
            }
        });
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
                SuccessActivity.this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
            }
        });
    }

    private Pair<? extends CharSequence, CharSequence> buildUiStringPair(int resultCode) {
        Pair stringIds = (Pair)resultCodesToStringIds.get(resultCode);
        return Pair.create((Object)this.getString((Integer)stringIds.first), (Object)Phrase.from((Context)this, (int)((Integer)stringIds.second)).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
    }

    static {
        resultCodesToStringIds.put(1, (Object)Pair.create((Object)R.string.setup_success_summary, (Object)R.string.setup_success_details));
        resultCodesToStringIds.put(2, (Object)Pair.create((Object)R.string.setup_success_unknown_ownership_summary, (Object)R.string.setup_success_unknown_ownership_details));
        resultCodesToStringIds.put(3, (Object)Pair.create((Object)R.string.setup_failure_claiming_summary, (Object)R.string.setup_failure_claiming_details));
        resultCodesToStringIds.put(4, (Object)Pair.create((Object)R.string.setup_failure_configure_summary, (Object)R.string.setup_failure_configure_details));
        resultCodesToStringIds.put(5, (Object)Pair.create((Object)R.string.setup_failure_no_disconnect_from_device_summary, (Object)R.string.setup_failure_no_disconnect_from_device_details));
        resultCodesToStringIds.put(6, (Object)Pair.create((Object)R.string.setup_failure_configure_summary, (Object)R.string.setup_failure_lost_connection_to_device));
    }
}

