/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.Loader;
import android.support.v7.app.AlertDialog;
import android.view.View;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.DeviceIdCommand;
import io.particle.android.sdk.devicesetup.commands.InterfaceBindingSocketFactory;
import io.particle.android.sdk.devicesetup.commands.PublicKeyCommand;
import io.particle.android.sdk.devicesetup.commands.SetCommand;
import io.particle.android.sdk.devicesetup.loaders.WifiScanResultLoader;
import io.particle.android.sdk.devicesetup.model.ScanResultNetwork;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.ui.ConnectToApFragment;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.GetReadyActivity;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.SelectNetworkActivity;
import io.particle.android.sdk.devicesetup.ui.WifiListFragment;
import io.particle.android.sdk.utils.Crypto;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WiFi;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

public class DiscoverDeviceActivity
extends RequiresWifiScansActivity
implements WifiListFragment.Client<ScanResultNetwork>,
ConnectToApFragment.Client {
    private static final int MAX_NUM_DISCOVER_PROCESS_ATTEMPTS = 5;
    private static final long CONNECT_TO_DEVICE_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(20L);
    private static final TLog log = TLog.get(DiscoverDeviceActivity.class);
    private WifiManager wifiManager;
    private ParticleCloud sparkCloud;
    private DiscoverProcessWorker discoverProcessWorker;
    private SoftAPConfigRemover softAPConfigRemover;
    private WifiListFragment wifiListFragment;
    private ProgressDialog connectToApSpinnerDialog;
    private AsyncTask<Void, Void, SetupStepException> connectToApTask;
    private boolean isResumed = false;
    private int discoverProcessAttempts = 0;
    private String currentSSID;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_discover_device);
        this.softAPConfigRemover = new SoftAPConfigRemover((Context)this);
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        DeviceSetupState.previouslyConnectedWifiNetwork = WiFi.getCurrentlyConnectedSSID((Context)this);
        this.wifiManager = (WifiManager)this.getSystemService("wifi");
        this.sparkCloud = ParticleCloud.get((Context)this);
        this.wifiListFragment = (WifiListFragment)((Object)Ui.findFrag((FragmentActivity)this, R.id.wifi_list_fragment));
        ConnectToApFragment.ensureAttached((FragmentActivity)this);
        this.resetWorker();
        Ui.setText((FragmentActivity)this, R.id.wifi_list_header, Phrase.from((Context)this, (int)R.string.wifi_list_header_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
        Ui.setText((FragmentActivity)this, R.id.msg_device_not_listed, Phrase.from((Context)this, (int)R.string.msg_device_not_listed).put("device_name", (CharSequence)this.getString(R.string.device_name)).put("setup_button_identifier", (CharSequence)this.getString(R.string.mode_button_name)).put("indicator_light", (CharSequence)this.getString(R.string.indicator_light)).put("indicator_light_setup_color_name", (CharSequence)this.getString(R.string.listen_mode_led_color_name)).format());
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
                DiscoverDeviceActivity.this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
            }
        });
        Ui.setText((FragmentActivity)this, R.id.logged_in_as, Phrase.from((Context)this, (int)R.string.you_are_logged_in_as).put("username", (CharSequence)this.sparkCloud.getLoggedInUsername()).format());
        Ui.findView((FragmentActivity)this, R.id.action_log_out).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DiscoverDeviceActivity.this.sparkCloud.logOut();
                log.i("logged out, username is: " + DiscoverDeviceActivity.this.sparkCloud.getLoggedInUsername());
                DiscoverDeviceActivity.this.startActivity(new Intent((Context)DiscoverDeviceActivity.this, LoginActivity.class));
                DiscoverDeviceActivity.this.finish();
            }
        });
        Ui.findView((FragmentActivity)this, R.id.action_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DiscoverDeviceActivity.this.finish();
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
        if (!this.wifiManager.isWifiEnabled()) {
            this.onWifiDisabled();
        }
    }

    protected void onResume() {
        super.onResume();
        this.isResumed = true;
    }

    protected void onPause() {
        super.onPause();
        this.isResumed = false;
    }

    private void resetWorker() {
        this.discoverProcessWorker = new DiscoverProcessWorker(CommandClient.newClientUsingDefaultSocketAddress());
    }

    private void onWifiDisabled() {
        log.d("Wi-Fi disabled; prompting user");
        new AlertDialog.Builder((Context)this).setTitle(R.string.wifi_required).setPositiveButton(R.string.enable_wifi, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                log.i("Enabling Wi-Fi at the user's request.");
                DiscoverDeviceActivity.this.wifiManager.setWifiEnabled(true);
                DiscoverDeviceActivity.this.wifiListFragment.scanAsync();
            }
        }).setNegativeButton(R.string.exit_setup, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                DiscoverDeviceActivity.this.finish();
            }
        }).show();
    }

    @Override
    public void onNetworkSelected(ScanResultNetwork selectedNetwork) {
        WifiConfiguration wifiConfig = ConnectToApFragment.buildUnsecuredConfig(selectedNetwork.getSsid(), false);
        this.currentSSID = selectedNetwork.getSsid();
        this.connectToSoftAp(wifiConfig);
    }

    private void connectToSoftAp(WifiConfiguration config) {
        ++this.discoverProcessAttempts;
        this.softAPConfigRemover.onSoftApConfigured(config.SSID);
        ConnectToApFragment.get((FragmentActivity)this).connectToAP(config, CONNECT_TO_DEVICE_TIMEOUT_MILLIS);
        this.showProgressDialog();
    }

    @Override
    public Loader<Set<ScanResultNetwork>> createLoader(int id2, Bundle args) {
        return new WifiScanResultLoader((Context)this);
    }

    @Override
    public void onLoadFinished() {
    }

    @Override
    public String getListEmptyText() {
        return Phrase.from((Context)this, (int)R.string.empty_soft_ap_list_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
    }

    @Override
    public int getAggroLoadingTimeMillis() {
        return 5000;
    }

    @Override
    public void onApConnectionSuccessful(WifiConfiguration config) {
        this.startConnectWorker();
    }

    @Override
    public void onApConnectionFailed(WifiConfiguration config) {
        this.hideProgressDialog();
        if (!this.canStartProcessAgain()) {
            this.onMaxAttemptsReached();
        } else {
            this.connectToSoftAp(config);
        }
    }

    private void showProgressDialog() {
        this.wifiListFragment.stopAggroLoading();
        String msg = Phrase.from((Context)this, (int)R.string.connecting_to_soft_ap).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
        this.connectToApSpinnerDialog = new ProgressDialog((Context)this);
        this.connectToApSpinnerDialog.setMessage((CharSequence)msg);
        this.connectToApSpinnerDialog.setCancelable(false);
        this.connectToApSpinnerDialog.setIndeterminate(true);
        this.connectToApSpinnerDialog.show();
    }

    private void hideProgressDialog() {
        this.wifiListFragment.startAggroLoading();
        if (this.connectToApSpinnerDialog != null) {
            if (!this.isFinishing()) {
                this.connectToApSpinnerDialog.dismiss();
            }
            this.connectToApSpinnerDialog = null;
        }
    }

    private void startConnectWorker() {
        if (this.connectToApTask != null) {
            log.d("Already running connect worker " + this.connectToApTask + ", refusing to start another");
            return;
        }
        this.wifiListFragment.stopAggroLoading();
        if (!this.canStartProcessAgain()) {
            this.hideProgressDialog();
            this.onMaxAttemptsReached();
            return;
        }
        ++this.discoverProcessAttempts;
        this.connectToApTask = new AsyncTask<Void, Void, SetupStepException>(){

            protected SetupStepException doInBackground(Void ... voids) {
                try {
                    log.d("Waiting a couple seconds before trying the socket connection...");
                    EZ.threadSleep((long)2000L);
                    DiscoverDeviceActivity.this.discoverProcessWorker.doTheThing(new InterfaceBindingSocketFactory((Context)DiscoverDeviceActivity.this, DiscoverDeviceActivity.this.currentSSID));
                    return null;
                }
                catch (SetupStepException e) {
                    log.d("Setup exception thrown: ", (Throwable)e);
                    return e;
                }
            }

            protected void onPostExecute(SetupStepException error) {
                DiscoverDeviceActivity.this.connectToApTask = null;
                if (error == null) {
                    DiscoverDeviceActivity.this.hideProgressDialog();
                    DiscoverDeviceActivity.this.startActivity(new Intent((Context)DiscoverDeviceActivity.this, SelectNetworkActivity.class));
                    DiscoverDeviceActivity.this.finish();
                } else if (error instanceof DeviceAlreadyClaimed) {
                    DiscoverDeviceActivity.this.hideProgressDialog();
                    DiscoverDeviceActivity.this.onDeviceClaimedByOtherUser();
                } else {
                    DiscoverDeviceActivity.this.startConnectWorker();
                }
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
    }

    private boolean canStartProcessAgain() {
        return this.discoverProcessAttempts < 5;
    }

    private void onMaxAttemptsReached() {
        if (!this.isResumed) {
            this.finish();
            return;
        }
        String errorMsg = Phrase.from((Context)this, (int)R.string.unable_to_connect_to_soft_ap).put("device_name", (CharSequence)this.getString(R.string.device_name)).format().toString();
        new AlertDialog.Builder((Context)this).setTitle(R.string.error).setMessage((CharSequence)errorMsg).setPositiveButton(R.string.ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                DiscoverDeviceActivity.this.startActivity(new Intent((Context)DiscoverDeviceActivity.this, GetReadyActivity.class));
                DiscoverDeviceActivity.this.finish();
            }
        }).show();
    }

    private void onDeviceClaimedByOtherUser() {
        String dialogMsg = String.format("This %s is owned by another user.  Change owner to %s?", this.getString(R.string.device_name), this.sparkCloud.getLoggedInUsername());
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)"Change owner?").setMessage((CharSequence)dialogMsg).setPositiveButton((CharSequence)"Change owner", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                log.i("Changing owner to " + DiscoverDeviceActivity.this.sparkCloud.getLoggedInUsername());
                DiscoverDeviceActivity.this.resetWorker();
                DiscoverDeviceActivity.this.discoverProcessWorker.needToClaimDevice = true;
                DiscoverDeviceActivity.this.discoverProcessWorker.gotOwnershipInfo = true;
                DiscoverDeviceActivity.this.discoverProcessWorker.isDetectedDeviceClaimed = false;
                DeviceSetupState.deviceNeedsToBeClaimed = true;
                DiscoverDeviceActivity.this.showProgressDialog();
                DiscoverDeviceActivity.this.startConnectWorker();
            }
        }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                DiscoverDeviceActivity.this.startActivity(new Intent((Context)DiscoverDeviceActivity.this, GetReadyActivity.class));
                DiscoverDeviceActivity.this.finish();
            }
        }).show();
    }

    static class DeviceAlreadyClaimed
    extends SetupStepException {
        public DeviceAlreadyClaimed(String msg, Throwable throwable) {
            super(msg, throwable);
        }

        public DeviceAlreadyClaimed(String msg) {
            super(msg);
        }

        public DeviceAlreadyClaimed(Throwable throwable) {
            super(throwable);
        }
    }

    static class DiscoverProcessWorker {
        private final CommandClient client;
        private String detectedDeviceID;
        private volatile boolean isDetectedDeviceClaimed;
        private volatile boolean gotOwnershipInfo;
        private volatile boolean needToClaimDevice;

        DiscoverProcessWorker(CommandClient client) {
            this.client = client;
        }

        public void doTheThing(InterfaceBindingSocketFactory socketFactory) throws SetupStepException {
            if (!Py.truthy((Object)this.detectedDeviceID)) {
                try {
                    DeviceIdCommand.Response response = this.client.sendCommandAndReturnResponse(new DeviceIdCommand(), DeviceIdCommand.Response.class, socketFactory);
                    DeviceSetupState.deviceToBeSetUpId = this.detectedDeviceID = response.deviceIdHex.toLowerCase();
                    this.isDetectedDeviceClaimed = Py.truthy((Object)response.isClaimed);
                }
                catch (IOException e) {
                    throw new SetupStepException("Process died while trying to get the device ID", e);
                }
            }
            if (DeviceSetupState.publicKey == null) {
                try {
                    DeviceSetupState.publicKey = this.getPublicKey(socketFactory);
                }
                catch (Crypto.CryptoException e) {
                    throw new SetupStepException("Unable to get public key: ", e);
                }
                catch (IOException e) {
                    throw new SetupStepException("Error while fetching public key: ", e);
                }
            }
            if (!this.gotOwnershipInfo) {
                this.needToClaimDevice = false;
                if (this.isDetectedDeviceClaimed) {
                    boolean deviceClaimedByUser = false;
                    for (String deviceId : DeviceSetupState.claimedDeviceIds) {
                        if (!deviceId.equalsIgnoreCase(this.detectedDeviceID)) continue;
                        deviceClaimedByUser = true;
                        break;
                    }
                    this.gotOwnershipInfo = true;
                    if (this.isDetectedDeviceClaimed && !deviceClaimedByUser) {
                        throw new DeviceAlreadyClaimed("Device already claimed by another user");
                    }
                    return;
                }
            } else {
                if (this.needToClaimDevice) {
                    this.setClaimCode(socketFactory);
                }
                return;
            }
            this.setClaimCode(socketFactory);
            this.needToClaimDevice = true;
        }

        private void setClaimCode(InterfaceBindingSocketFactory socketFactory) throws SetupStepException {
            try {
                log.d("Setting claim code using code: " + DeviceSetupState.claimCode);
                SetCommand.Response response = this.client.sendCommandAndReturnResponse(new SetCommand("cc", StringUtils.remove((String)DeviceSetupState.claimCode, (String)"\\")), SetCommand.Response.class, socketFactory);
                if (Py.truthy((Object)response.responseCode)) {
                    throw new SetupStepException("Received non-zero return code from set command: " + response.responseCode);
                }
                log.d("Successfully set claim code");
            }
            catch (IOException e) {
                throw new SetupStepException(e);
            }
        }

        private PublicKey getPublicKey(InterfaceBindingSocketFactory socketFactory) throws Crypto.CryptoException, IOException {
            PublicKeyCommand.Response response = this.client.sendCommandAndReturnResponse(new PublicKeyCommand(), PublicKeyCommand.Response.class, socketFactory);
            return Crypto.readPublicKeyFromHexEncodedDerString(response.publicKey);
        }
    }
}

