/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.commands;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import io.particle.android.sdk.devicesetup.commands.CeciNestPasUnSocketFactory;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WiFi;
import java.io.IOException;
import java.net.Socket;

public class InterfaceBindingSocketFactory
implements CeciNestPasUnSocketFactory {
    private static final TLog log = TLog.get(InterfaceBindingSocketFactory.class);
    private final Context ctx;
    private final String softAPSSID;

    public InterfaceBindingSocketFactory(Context ctx) {
        this(ctx, WiFi.getCurrentlyConnectedSSID(ctx));
    }

    public InterfaceBindingSocketFactory(Context ctx, String softAPSSID) {
        this.ctx = ctx.getApplicationContext();
        this.softAPSSID = softAPSSID;
    }

    @Override
    public Socket buildSocket(int readTimeoutMillis) throws IOException {
        Socket socket = new Socket();
        socket.setSoTimeout(readTimeoutMillis);
        if (Build.VERSION.SDK_INT >= 21) {
            this.bindSocketToSoftAp(socket);
        }
        return socket;
    }

    @TargetApi(value=21)
    private void bindSocketToSoftAp(Socket socket) throws IllegalArgumentException, IOException {
        ConnectivityManager connMan = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        Network softAp = null;
        for (Network network : connMan.getAllNetworks()) {
            log.i("Inspecting network:  " + network);
            NetworkInfo networkInfo = connMan.getNetworkInfo(network);
            log.i("Inspecting network info:  " + networkInfo);
            String dequotifiedNetworkExtraSsid = WiFi.deQuotifySsid(networkInfo.getExtraInfo());
            String dequotifiedTargetSsid = WiFi.deQuotifySsid(this.softAPSSID);
            log.i("Network extra info: '" + dequotifiedNetworkExtraSsid + "'");
            log.i("And the SSID we were to connect to: '" + dequotifiedTargetSsid + "'");
            if (!dequotifiedTargetSsid.equalsIgnoreCase(dequotifiedNetworkExtraSsid)) continue;
            softAp = network;
            break;
        }
        if (softAp == null) {
            throw new IllegalArgumentException("Could not find Network for SSID " + this.softAPSSID);
        }
        softAp.bindSocket(socket);
    }
}

