/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.Theme;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.WorkerFragment;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.Arrays;
import java.util.Set;

public class PermissionsFragment
extends Fragment
implements ActivityCompat.OnRequestPermissionsResultCallback {
    public static final String TAG = WorkerFragment.buildFragmentTag(PermissionsFragment.class);
    private static final int REQUEST_CODE = 128;
    private static final String PREF_BUCKET_NAME = "permissionsFragmentPrefs";
    private static final String PREF_KEY_PERMISSION_DIALOGS_SHOWN = "permissionsDialogsShown";

    public static <T extends FragmentActivity> PermissionsFragment ensureAttached(T callbacksActivity) {
        PermissionsFragment frag = PermissionsFragment.get(callbacksActivity);
        if (frag == null) {
            frag = new PermissionsFragment();
            WorkerFragment.addFragment(callbacksActivity, frag, TAG);
        }
        return frag;
    }

    public static <T extends FragmentActivity> PermissionsFragment get(T callbacksActivity) {
        return (PermissionsFragment)((Object)Ui.findFrag(callbacksActivity, TAG));
    }

    public static boolean hasPermission(@NonNull Context ctx, @NonNull String permission2) {
        int result = ContextCompat.checkSelfPermission((Context)ctx, (String)permission2);
        return result == 0;
    }

    public void ensurePermission(final @NonNull String permission2) {
        if (!PermissionsFragment.haveShownPermissionDialog((Context)this.getActivity(), permission2)) {
            this.requestPermission(permission2);
            PermissionsFragment.markPermissionDialogShown((Context)this.getActivity(), permission2);
            return;
        }
        MaterialDialog.Builder dialogBuilder = new MaterialDialog.Builder((Context)this.getActivity()).theme(Theme.LIGHT).cancelable(false).autoDismiss(true);
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this.getActivity(), (String)permission2)) {
            dialogBuilder.title(R.string.location_permission_dialog_title).content(R.string.location_permission_dialog_text).positiveText(R.string.got_it).callback(new MaterialDialog.ButtonCallback(){

                public void onPositive(MaterialDialog dialog) {
                    PermissionsFragment.this.requestPermission(permission2);
                }
            });
        } else {
            dialogBuilder.title(R.string.location_permission_denied_dialog_title).content(R.string.location_permission_denied_dialog_text).positiveText((CharSequence)"Settings").negativeText((CharSequence)"Exit setup").callback(new MaterialDialog.ButtonCallback(){

                public void onPositive(MaterialDialog dialog) {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    String pkgName = PermissionsFragment.this.getActivity().getApplicationInfo().packageName;
                    intent.setData(Uri.parse((String)("package:" + pkgName)));
                    PermissionsFragment.this.startActivity(intent);
                }

                public void onNegative(MaterialDialog dialog) {
                    Client client = (Client)PermissionsFragment.this.getActivity();
                    client.onUserDeniedPermission(permission2);
                }
            });
        }
        dialogBuilder.show();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        Log.i((String)TAG, (String)String.format("onRequestPermissionsResult(%d, %s, %s)", requestCode, Arrays.toString(permissions), Arrays.toString(grantResults)));
        if (requestCode != 128) {
            Log.i((String)TAG, (String)("Unrecognized request code: " + requestCode));
        }
        String permission2 = permissions[0];
        if (PermissionsFragment.hasPermission((Context)this.getActivity(), permission2)) {
            Client client = (Client)this.getActivity();
            client.onUserAllowedPermission(permission2);
        } else {
            this.ensurePermission(permission2);
        }
    }

    private void requestPermission(String permission2) {
        ActivityCompat.requestPermissions((Activity)this.getActivity(), (String[])new String[]{permission2}, (int)128);
    }

    private static boolean haveShownPermissionDialog(Context ctx, String permission2) {
        SharedPreferences prefs = ctx.getSharedPreferences(PREF_BUCKET_NAME, 0);
        Object permissions = Py.set((Object[])new String[0]);
        permissions = prefs.getStringSet(PREF_KEY_PERMISSION_DIALOGS_SHOWN, (Set)permissions);
        return permissions.contains(permission2);
    }

    private static void markPermissionDialogShown(Context ctx, String permission2) {
        Object permissions = Py.set((Object[])new String[0]);
        SharedPreferences prefs = ctx.getSharedPreferences(PREF_BUCKET_NAME, 0);
        permissions = prefs.getStringSet(PREF_KEY_PERMISSION_DIALOGS_SHOWN, (Set)permissions);
        permissions.add(permission2);
        prefs.edit().putStringSet(PREF_KEY_PERMISSION_DIALOGS_SHOWN, (Set)permissions).apply();
    }

    public static interface Client {
        public void onUserAllowedPermission(String var1);

        public void onUserDeniedPermission(String var1);
    }
}

