/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.google.gson.Gson;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudException;
import io.particle.android.sdk.cloud.ParticleDevice;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.SetupProcessException;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.setupsteps.CheckIfDeviceClaimedStep;
import io.particle.android.sdk.devicesetup.setupsteps.ConfigureAPStep;
import io.particle.android.sdk.devicesetup.setupsteps.ConnectDeviceToNetworkStep;
import io.particle.android.sdk.devicesetup.setupsteps.EnsureSoftApNotVisible;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepsRunnerTask;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.devicesetup.setupsteps.StepProgress;
import io.particle.android.sdk.devicesetup.setupsteps.WaitForCloudConnectivityStep;
import io.particle.android.sdk.devicesetup.setupsteps.WaitForDisconnectionFromDeviceStep;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.RequiresWifiScansActivity;
import io.particle.android.sdk.devicesetup.ui.SuccessActivity;
import io.particle.android.sdk.utils.CoreNameGenerator;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.Ui;
import java.security.PublicKey;
import java.util.List;
import java.util.Set;

public class ConnectingActivity
extends RequiresWifiScansActivity {
    public static final String EXTRA_NETWORK_TO_CONFIGURE = "EXTRA_NETWORK_TO_CONFIGURE";
    public static final String EXTRA_NETWORK_SECRET = "EXTRA_NETWORK_SECRET";
    public static final String EXTRA_SOFT_AP_SSID = "EXTRA_SOFT_AP_SSID";
    private static final int MAX_RETRIES_CONFIGURE_AP = 5;
    private static final int MAX_RETRIES_CONNECT_AP = 5;
    private static final int MAX_RETRIES_DISCONNECT_FROM_DEVICE = 5;
    private static final int MAX_RETRIES_CLAIM = 5;
    private static final TLog log = TLog.get(ConnectingActivity.class);
    private static final Gson gson = new Gson();
    private CommandClient client;
    private ConnectingProcessWorkerTask connectingProcessWorkerTask;
    private SoftAPConfigRemover softAPConfigRemover;
    private ScanApCommand.Scan networkToConnectTo;
    private String networkSecretPlaintext;
    private PublicKey publicKey;
    private String deviceSoftApSsid;
    private ParticleCloud sparkCloud;
    private String deviceId;
    private boolean needToClaimDevice;
    private Drawable tintedSpinner;
    private Drawable tintedCheckmark;

    public static Intent buildIntent(Context ctx, String deviceSoftApSsid, ScanApCommand.Scan networkToConnectTo) {
        return new Intent(ctx, ConnectingActivity.class).putExtra(EXTRA_NETWORK_TO_CONFIGURE, gson.toJson((Object)networkToConnectTo)).putExtra(EXTRA_SOFT_AP_SSID, deviceSoftApSsid);
    }

    public static Intent buildIntent(Context ctx, String deviceSoftApSsid, ScanApCommand.Scan networkToConnectTo, String secret) {
        return ConnectingActivity.buildIntent(ctx, deviceSoftApSsid, networkToConnectTo).putExtra(EXTRA_NETWORK_SECRET, secret);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_connecting);
        this.softAPConfigRemover = new SoftAPConfigRemover((Context)this);
        this.publicKey = DeviceSetupState.publicKey;
        this.sparkCloud = ParticleCloud.get((Context)this);
        this.deviceId = DeviceSetupState.deviceToBeSetUpId;
        this.needToClaimDevice = DeviceSetupState.deviceNeedsToBeClaimed;
        this.deviceSoftApSsid = this.getIntent().getStringExtra(EXTRA_SOFT_AP_SSID);
        String asJson = this.getIntent().getStringExtra(EXTRA_NETWORK_TO_CONFIGURE);
        this.networkToConnectTo = (ScanApCommand.Scan)gson.fromJson(asJson, ScanApCommand.Scan.class);
        this.networkSecretPlaintext = this.getIntent().getStringExtra(EXTRA_NETWORK_SECRET);
        this.client = CommandClient.newClientUsingDefaultSocketAddress();
        log.d("Connecting to " + this.networkToConnectTo + ", with networkSecretPlaintext of size: " + (this.networkSecretPlaintext == null ? 0 : this.networkSecretPlaintext.length()));
        Ui.setText((FragmentActivity)this, R.id.network_name, (CharSequence)this.networkToConnectTo.ssid);
        Button cancelButton = (Button)Ui.findView((FragmentActivity)this, R.id.action_cancel);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ConnectingActivity.this.connectingProcessWorkerTask.cancel(false);
                ConnectingActivity.this.finish();
            }
        });
        Ui.setText((FragmentActivity)this, R.id.connecting_text, Phrase.from((Context)this, (int)R.string.connecting_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
        Ui.setText((FragmentActivity)this, R.id.network_name, (CharSequence)this.networkToConnectTo.ssid);
        this.tintedSpinner = Ui.getTintedDrawable((Context)this, R.drawable.progress_spinner, R.color.element_text_color);
        this.tintedCheckmark = Ui.getTintedDrawable((Context)this, R.drawable.checkmark, R.color.element_text_color);
        this.connectingProcessWorkerTask = new ConnectingProcessWorkerTask(this.buildSteps(), 15);
        this.connectingProcessWorkerTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    protected void onStop() {
        super.onStop();
        if (this.isFinishing() && this.connectingProcessWorkerTask != null && !this.connectingProcessWorkerTask.isCancelled()) {
            this.connectingProcessWorkerTask.cancel(true);
            this.connectingProcessWorkerTask = null;
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
    }

    private List<SetupStep> buildSteps() {
        ConfigureAPStep configureAPStep = new ConfigureAPStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(4).setStepId(R.id.configure_device_wifi_credentials).build(), this.client, this.networkToConnectTo, this.networkSecretPlaintext, this.publicKey, (Context)this);
        ConnectDeviceToNetworkStep connectDeviceToNetworkStep = new ConnectDeviceToNetworkStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(4).setStepId(R.id.connect_to_wifi_network).build(), this.client, (Context)this);
        WaitForDisconnectionFromDeviceStep waitForDisconnectionFromDeviceStep = new WaitForDisconnectionFromDeviceStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(5).setStepId(R.id.connect_to_wifi_network).build(), this.deviceSoftApSsid, (Context)this);
        EnsureSoftApNotVisible ensureSoftApNotVisible = new EnsureSoftApNotVisible(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(4).setStepId(R.id.wait_for_device_cloud_connection).build(), this.deviceSoftApSsid, (Context)this);
        WaitForCloudConnectivityStep waitForLocalCloudConnectivityStep = new WaitForCloudConnectivityStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(5).setStepId(R.id.check_for_internet_connectivity).build(), this.sparkCloud, this.getApplicationContext());
        CheckIfDeviceClaimedStep checkIfDeviceClaimedStep = new CheckIfDeviceClaimedStep(StepConfig.newBuilder().setMaxAttempts(5).setResultCode(3).setStepId(R.id.verify_product_ownership).build(), this.sparkCloud, this.deviceId, this.needToClaimDevice);
        return Py.list((Object[])new SetupStep[]{configureAPStep, connectDeviceToNetworkStep, waitForDisconnectionFromDeviceStep, ensureSoftApNotVisible, waitForLocalCloudConnectivityStep, checkIfDeviceClaimedStep});
    }

    class ConnectingProcessWorkerTask
    extends SetupStepsRunnerTask {
        ConnectingProcessWorkerTask(List<SetupStep> steps, int max) {
            super(steps, max);
        }

        protected void onProgressUpdate(StepProgress ... values) {
            for (StepProgress progress : values) {
                View v = ConnectingActivity.this.findViewById(progress.stepId);
                if (v == null) continue;
                this.updateProgress(progress, v);
            }
        }

        protected void onPostExecute(SetupProcessException error) {
            int resultCode;
            if (error == null) {
                log.i("HUZZAH, VICTORY!");
                resultCode = 1;
                EZ.runAsync((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Py.PySet names = Py.set((Object[])new String[0]);
                            for (ParticleDevice device : ConnectingActivity.this.sparkCloud.getDevices()) {
                                if (device == null || device.getName() == null) continue;
                                names.add(device.getName());
                            }
                            ParticleDevice device = ConnectingActivity.this.sparkCloud.getDevice(ConnectingActivity.this.deviceId);
                            if (device != null && !Py.truthy((Object)device.getName())) {
                                device.setName(CoreNameGenerator.generateUniqueName((Set<String>)names));
                            }
                        }
                        catch (ParticleCloudException e) {
                            e.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                resultCode = error.failedStep.getStepConfig().resultCode;
            }
            ConnectingActivity.this.startActivity(SuccessActivity.buildIntent((Context)ConnectingActivity.this, resultCode));
            ConnectingActivity.this.finish();
        }

        private void updateProgress(StepProgress progress, View progressStepContainer) {
            ProgressBar progBar = (ProgressBar)Ui.findView(progressStepContainer, R.id.spinner);
            ImageView checkmark = (ImageView)Ui.findView(progressStepContainer, R.id.checkbox);
            if (checkmark.getVisibility() == 0) {
                return;
            }
            progressStepContainer.setVisibility(0);
            if (progress.status == 1) {
                checkmark.setVisibility(8);
                progBar.setProgressDrawable(ConnectingActivity.this.tintedSpinner);
                progBar.setVisibility(0);
            } else {
                progBar.setVisibility(8);
                checkmark.setImageDrawable(ConnectingActivity.this.tintedCheckmark);
                checkmark.setVisibility(0);
            }
        }
    }
}

