/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.loaders;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.model.ScanResultNetwork;
import io.particle.android.sdk.utils.BetterAsyncTaskLoader;
import io.particle.android.sdk.utils.TLog;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class WifiScanResultLoader
extends BetterAsyncTaskLoader<Set<ScanResultNetwork>> {
    private static final TLog log = TLog.get(WifiScanResultLoader.class);
    private final WifiManager wifiManager;
    private final WifiScannedBroadcastReceiver receiver = new WifiScannedBroadcastReceiver();
    private volatile ImmutableSet<ScanResultNetwork> mostRecentResult;
    private volatile int loadCount = 0;
    private Predicate<ScanResult> ssidStartsWithProductName = new Predicate<ScanResult>(){
        final String softApPrefix = this.getPrefix();

        public boolean apply(ScanResult input) {
            return input.SSID != null && input.SSID.toLowerCase().startsWith(this.softApPrefix);
        }

        String getPrefix() {
            return (WifiScanResultLoader.this.getContext().getString(R.string.network_name_prefix) + "-").toLowerCase();
        }
    };
    private static Function<ScanResult, ScanResultNetwork> toWifiNetwork = new Function<ScanResult, ScanResultNetwork>(){

        public ScanResultNetwork apply(ScanResult input) {
            return new ScanResultNetwork(input);
        }
    };

    public WifiScanResultLoader(Context context) {
        super(context);
        this.wifiManager = (WifiManager)context.getSystemService("wifi");
    }

    @Override
    public boolean hasContent() {
        return this.mostRecentResult != null;
    }

    @Override
    public Set<ScanResultNetwork> getLoadedContent() {
        return this.mostRecentResult;
    }

    @Override
    protected void onStartLoading() {
        super.onStartLoading();
        this.getContext().registerReceiver((BroadcastReceiver)this.receiver, this.receiver.buildIntentFilter());
        this.forceLoad();
    }

    protected void onStopLoading() {
        this.getContext().unregisterReceiver((BroadcastReceiver)this.receiver);
        this.cancelLoad();
    }

    public Set<ScanResultNetwork> loadInBackground() {
        List scanResults = this.wifiManager.getScanResults();
        log.d("Latest (unfiltered) scan results: " + scanResults);
        if (scanResults == null) {
            scanResults = Collections.emptyList();
            log.wtf("wifiManager.getScanResults() returned null??");
        }
        if (this.loadCount % 3 == 0) {
            this.wifiManager.startScan();
        }
        ++this.loadCount;
        this.mostRecentResult = FluentIterable.from(scanResults).filter(this.ssidStartsWithProductName).transform(toWifiNetwork).toSet();
        if (this.mostRecentResult.isEmpty()) {
            log.i("No SSID scan results returned after filtering by product name.  Do you need to change the 'network_name_prefix' resource?");
        }
        return this.mostRecentResult;
    }

    private class WifiScannedBroadcastReceiver
    extends BroadcastReceiver {
        private WifiScannedBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            log.d("Received WifiManager.SCAN_RESULTS_AVAILABLE_ACTION broadcast");
            WifiScanResultLoader.this.forceLoad();
        }

        IntentFilter buildIntentFilter() {
            return new IntentFilter("android.net.wifi.SCAN_RESULTS");
        }
    }
}

