/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import io.particle.android.sdk.accountsetup.CreateAccountActivity;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.devicesetup.ParticleDeviceSetupLibrary;
import io.particle.android.sdk.devicesetup.ui.GetReadyActivity;
import io.particle.android.sdk.persistance.AppDataStorage;
import io.particle.android.sdk.persistance.SensitiveDataStorage;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;

public class NextActivitySelector {
    private static final TLog log = TLog.get(NextActivitySelector.class);
    private final SparkCloud cloud;
    private final SensitiveDataStorage credStorage;
    private final AppDataStorage appData;
    private final Class<? extends Activity> mainActivityClass;

    private NextActivitySelector(SparkCloud cloud, SensitiveDataStorage credStorage, AppDataStorage appData, Class<? extends Activity> mainActivityClass) {
        this.cloud = cloud;
        this.credStorage = credStorage;
        this.appData = appData;
        this.mainActivityClass = mainActivityClass;
    }

    public static Intent getNextActivityIntent(Context ctx, SparkCloud sparkCloud, SensitiveDataStorage credStorage, AppDataStorage appDataStorage) {
        NextActivitySelector selector = new NextActivitySelector(sparkCloud, credStorage, appDataStorage, ParticleDeviceSetupLibrary.getInstance().getMainActivityClass());
        Class<? extends Activity> nextActivity = selector.buildIntentForNextActivity();
        return new Intent(ctx, nextActivity);
    }

    Class<? extends Activity> buildIntentForNextActivity() {
        if (!this.hasUserBeenLoggedInBefore()) {
            log.d("User has not been logged in before");
            return CreateAccountActivity.class;
        }
        if (!this.isOAuthTokenPresent()) {
            log.d("No auth token present");
            return LoginActivity.class;
        }
        if (!this.userAccountHasDevicesClaimed()) {
            log.d("User has no devices claimed");
            return GetReadyActivity.class;
        }
        log.d("Returning default activity");
        return this.mainActivityClass;
    }

    boolean hasUserBeenLoggedInBefore() {
        return Py.truthy((Object)this.credStorage.getUser());
    }

    boolean isOAuthTokenPresent() {
        return Py.truthy((Object)this.cloud.getAccessToken());
    }

    boolean userAccountHasDevicesClaimed() {
        return this.appData.getUserHasClaimedDevices();
    }
}

