/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.Theme;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.devicesetup.ui.DeviceSetupState;
import io.particle.android.sdk.devicesetup.ui.DiscoverDeviceActivity;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;
import java.util.Arrays;

public class GetReadyActivity
extends BaseActivity {
    private static final TLog log = TLog.get(GetReadyActivity.class);
    private SparkCloud sparkCloud;
    private SoftAPConfigRemover softAPConfigRemover;
    private Async.AsyncApiWorker<SparkCloud, Responses.ClaimCodeResponse> claimCodeWorker;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_get_ready);
        this.sparkCloud = SparkCloud.get((Context)this);
        this.softAPConfigRemover = new SoftAPConfigRemover((Context)this);
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        Ui.findView((FragmentActivity)this, R.id.action_im_ready).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GetReadyActivity.this.onReadyButtonClicked();
            }
        });
        Ui.setTextFromHtml((FragmentActivity)this, R.id.action_troubleshooting, R.string.troubleshooting).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Uri uri = Uri.parse((String)v.getContext().getString(R.string.troubleshooting_uri));
                GetReadyActivity.this.startActivity(WebViewActivity.buildIntent(v.getContext(), uri));
            }
        });
        Ui.setText((FragmentActivity)this, R.id.get_ready_text, Phrase.from((Context)this, (int)R.string.get_ready_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).put("indicator_light_setup_color_name", (CharSequence)this.getString(R.string.listen_mode_led_color_name)).put("setup_button_identifier", (CharSequence)this.getString(R.string.mode_button_name)).format());
        Ui.setText((FragmentActivity)this, R.id.get_ready_text_title, Phrase.from((Context)this, (int)R.string.get_ready_title_text).put("device_name", (CharSequence)this.getString(R.string.device_name)).format());
    }

    protected void onStart() {
        super.onStart();
        log.i(((Object)((Object)this)).getClass().getSimpleName() + ".onStart()");
        this.softAPConfigRemover.removeAllSoftApConfigs();
        this.softAPConfigRemover.reenableWifiNetworks();
        if (this.sparkCloud.getLoggedInUsername() == null) {
            this.startLoginActivity();
            this.finish();
        }
    }

    private void onReadyButtonClicked() {
        DeviceSetupState.reset();
        this.showProgress(true);
        this.claimCodeWorker = Async.executeAsync((SparkCloud)this.sparkCloud, (Async.ApiWork)new Async.ApiWork<SparkCloud, Responses.ClaimCodeResponse>(){

            public Responses.ClaimCodeResponse callApi(SparkCloud sparkCloud) throws SparkCloudException {
                return sparkCloud.generateClaimCode();
            }

            public void onTaskFinished() {
                GetReadyActivity.this.claimCodeWorker = null;
                GetReadyActivity.this.showProgress(false);
            }

            public void onSuccess(Responses.ClaimCodeResponse result) {
                log.d("Claim code generated: " + result.claimCode);
                DeviceSetupState.claimCode = result.claimCode;
                if (Py.truthy((Object)result.deviceIds)) {
                    DeviceSetupState.claimedDeviceIds.addAll(Arrays.asList(result.deviceIds));
                }
                if (!GetReadyActivity.this.isFinishing()) {
                    GetReadyActivity.this.startActivity(new Intent((Context)GetReadyActivity.this, DiscoverDeviceActivity.class));
                }
            }

            public void onFailure(SparkCloudException error) {
                log.d("Generating claim code failed");
                SparkCloudException.ResponseErrorData errorData = error.getResponseData();
                if (errorData != null && errorData.getHttpStatusCode() == 401) {
                    if (GetReadyActivity.this.isFinishing()) {
                        GetReadyActivity.this.sparkCloud.logOut();
                        GetReadyActivity.this.startLoginActivity();
                        return;
                    }
                    String errorMsg = String.format("Sorry, you must be logged in as a %s customer.", GetReadyActivity.this.getString(R.string.brand_name));
                    new MaterialDialog.Builder((Context)GetReadyActivity.this).theme(Theme.LIGHT).title((CharSequence)GetReadyActivity.this.getString(R.string.access_denied)).content((CharSequence)errorMsg).positiveText((CharSequence)GetReadyActivity.this.getString(R.string.ok)).dismissListener(new DialogInterface.OnDismissListener(){

                        public void onDismiss(DialogInterface dialog) {
                            log.i("Logging out user");
                            GetReadyActivity.this.sparkCloud.logOut();
                            GetReadyActivity.this.startLoginActivity();
                            GetReadyActivity.this.finish();
                        }
                    }).autoDismiss(true).show();
                } else {
                    if (GetReadyActivity.this.isFinishing()) {
                        return;
                    }
                    String errorMsg = GetReadyActivity.this.getString(R.string.get_ready_could_not_connect_to_cloud);
                    if (error.getMessage() != null) {
                        errorMsg = errorMsg + "\n\n" + error.getMessage();
                    }
                    new MaterialDialog.Builder((Context)GetReadyActivity.this).theme(Theme.LIGHT).title((CharSequence)GetReadyActivity.this.getString(R.string.error)).content((CharSequence)errorMsg).positiveText((CharSequence)GetReadyActivity.this.getString(R.string.ok)).autoDismiss(true).show();
                }
            }
        });
    }

    private void startLoginActivity() {
        this.startActivity(new Intent((Context)this, LoginActivity.class));
    }

    private void showProgress(boolean show) {
        ParticleUi.showSparkButtonProgress((FragmentActivity)this, R.id.action_im_ready, show);
    }
}

