/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import io.particle.android.sdk.utils.EZ;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.SoftAPConfigRemover;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.WiFi;
import io.particle.android.sdk.utils.WorkerFragment;
import io.particle.android.sdk.utils.ui.Ui;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class ConnectToApFragment
extends WorkerFragment {
    public static final String TAG = WorkerFragment.buildFragmentTag(ConnectToApFragment.class);
    private static final TLog log = TLog.get(ConnectToApFragment.class);
    private WifiManager wifiManager;
    private BroadcastReceiver wifiStateChangeListener;
    private WifiStateChangeLogger wifiStateChangeLogger;
    private Context appContext;
    private ClientDecorator client;
    private SoftAPConfigRemover softAPConfigRemover;
    private Handler mainThreadHandler;
    private Runnable onTimeoutRunnable;
    private List<Runnable> setupRunnables = Py.list();

    public static ConnectToApFragment get(FragmentActivity activity) {
        return (ConnectToApFragment)((Object)Ui.findFrag(activity, TAG));
    }

    public static ConnectToApFragment ensureAttached(FragmentActivity activity) {
        ConnectToApFragment frag = ConnectToApFragment.get(activity);
        if (frag == null) {
            frag = new ConnectToApFragment();
            WorkerFragment.addFragment(activity, frag, TAG);
        }
        return frag;
    }

    public static WifiConfiguration buildUnsecuredConfig(String ssid, boolean isHidden) {
        WifiConfiguration config = ConnectToApFragment.buildBasicConfig(ssid, isHidden);
        config.allowedKeyManagement.set(0);
        config.priority = 999999;
        return config;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.wifiManager = (WifiManager)activity.getSystemService("wifi");
        this.softAPConfigRemover = new SoftAPConfigRemover(activity.getApplicationContext());
        this.mainThreadHandler = new Handler();
        this.client = new ClientDecorator();
        this.client.setDecoratedClient((Client)EZ.getCallbacksOrThrow((Fragment)this, Client.class));
        this.appContext = activity.getApplicationContext();
        this.wifiStateChangeLogger = new WifiStateChangeLogger();
    }

    public void onStart() {
        super.onStart();
        this.appContext.registerReceiver((BroadcastReceiver)this.wifiStateChangeLogger, this.wifiStateChangeLogger.buildIntentFilter());
    }

    public void onStop() {
        this.appContext.unregisterReceiver((BroadcastReceiver)this.wifiStateChangeLogger);
        super.onStop();
    }

    public void onDetach() {
        super.onDetach();
        this.client.setDecoratedClient(null);
    }

    public void onDestroy() {
        this.clearState();
        super.onDestroy();
    }

    public String connectToAP(final WifiConfiguration config, long timeoutInMillis) {
        this.clearState();
        WifiInfo currentConnectionInfo = this.wifiManager.getConnectionInfo();
        if (ConnectToApFragment.isAlreadyConnectedToTargetNetwork(currentConnectionInfo, config.SSID)) {
            this.client.onApConnectionSuccessful(config);
            return null;
        }
        this.scheduleTimeoutCheck(timeoutInMillis, config);
        this.wifiStateChangeListener = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                ConnectToApFragment.this.onWifiChangeBroadcastReceived(intent, config);
            }
        };
        this.appContext.registerReceiver(this.wifiStateChangeListener, new IntentFilter("android.net.wifi.STATE_CHANGE"));
        final boolean useMoreComplexConnectionProcess = Build.VERSION.SDK_INT < 18;
        final AtomicInteger networkID = new AtomicInteger(-1);
        final int alreadyConfiguredId = WiFi.getConfiguredNetworkId(config.SSID, (Context)this.getActivity());
        if (alreadyConfiguredId != -1 && !useMoreComplexConnectionProcess) {
            this.setupRunnables.add(new Runnable(){

                @Override
                public void run() {
                    if (ConnectToApFragment.this.wifiManager.removeNetwork(alreadyConfiguredId)) {
                        log.d("Removed already-configured " + config.SSID + " network successfully");
                    } else {
                        log.e("Somehow failed to remove the already-configured network!?");
                    }
                }
            });
        }
        if (alreadyConfiguredId == -1 || !useMoreComplexConnectionProcess) {
            this.setupRunnables.add(new Runnable(){

                @Override
                public void run() {
                    log.d("Adding network " + config.SSID);
                    networkID.set(ConnectToApFragment.this.wifiManager.addNetwork(config));
                    if (networkID.get() == -1) {
                        log.e("Adding network " + config.SSID + " failed.");
                        ConnectToApFragment.this.client.onApConnectionFailed(config);
                    } else {
                        log.i("Added network with ID " + networkID + " successfully");
                    }
                }
            });
        }
        if (useMoreComplexConnectionProcess) {
            this.setupRunnables.add(new Runnable(){

                @Override
                public void run() {
                    log.d("Disconnecting from networks; reconnecting momentarily.");
                    ConnectToApFragment.this.wifiManager.disconnect();
                }
            });
        }
        this.setupRunnables.add(new Runnable(){

            @Override
            public void run() {
                log.i("Enabling network " + config.SSID + " with network ID " + networkID.get());
                ConnectToApFragment.this.wifiManager.enableNetwork(networkID.get(), !useMoreComplexConnectionProcess);
            }
        });
        if (useMoreComplexConnectionProcess) {
            this.setupRunnables.add(new Runnable(){

                @Override
                public void run() {
                    log.d("Disconnecting from networks; reconnecting momentarily.");
                    ConnectToApFragment.this.wifiManager.reconnect();
                }
            });
        }
        String currentlyConnectedSSID = WiFi.getCurrentlyConnectedSSID((Context)this.getActivity());
        this.softAPConfigRemover.onWifiNetworkDisabled(currentlyConnectedSSID);
        long timeout = 0L;
        for (Runnable runnable : this.setupRunnables) {
            EZ.runOnMainThreadDelayed((long)timeout, (Runnable)runnable);
            timeout += 1500L;
        }
        return currentConnectionInfo.getSSID();
    }

    private static boolean isAlreadyConnectedToTargetNetwork(WifiInfo currentConnectionInfo, String targetNetworkSsid) {
        return ConnectToApFragment.isCurrentlyConnectedToAWifiNetwork(currentConnectionInfo) && targetNetworkSsid.equals(currentConnectionInfo.getSSID());
    }

    private static boolean isCurrentlyConnectedToAWifiNetwork(WifiInfo currentConnectionInfo) {
        return currentConnectionInfo != null && Py.truthy((Object)currentConnectionInfo.getSSID()) && currentConnectionInfo.getNetworkId() != -1 && !"0x".equals(currentConnectionInfo.getSSID());
    }

    private void scheduleTimeoutCheck(long timeoutInMillis, final WifiConfiguration config) {
        this.onTimeoutRunnable = new Runnable(){

            @Override
            public void run() {
                ConnectToApFragment.this.client.onApConnectionFailed(config);
            }
        };
        this.mainThreadHandler.postDelayed(this.onTimeoutRunnable, timeoutInMillis);
    }

    private void clearState() {
        if (this.onTimeoutRunnable != null) {
            this.mainThreadHandler.removeCallbacks(this.onTimeoutRunnable);
            this.onTimeoutRunnable = null;
        }
        if (this.wifiStateChangeListener != null) {
            this.appContext.unregisterReceiver(this.wifiStateChangeListener);
            this.wifiStateChangeListener = null;
        }
        for (Runnable runnable : this.setupRunnables) {
            this.mainThreadHandler.removeCallbacks(runnable);
        }
        this.setupRunnables.clear();
    }

    private void onWifiChangeBroadcastReceived(Intent intent, WifiConfiguration config) {
        WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
        if (wifiInfo == null || wifiInfo.getSSID() == null) {
            return;
        }
        log.i("Connected to: " + wifiInfo.getSSID());
        String ssid = wifiInfo.getSSID();
        if (ssid.equals(config.SSID) || WiFi.enQuotifySsid(ssid).equals(config.SSID)) {
            this.client.onApConnectionSuccessful(config);
        }
    }

    private static WifiConfiguration buildBasicConfig(String ssid, boolean isHidden) {
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = WiFi.enQuotifySsid(ssid);
        config.hiddenSSID = isHidden;
        return config;
    }

    private class ClientDecorator
    implements Client {
        Client decoratedClient;

        private ClientDecorator() {
        }

        @Override
        public void onApConnectionSuccessful(WifiConfiguration config) {
            if (this.decoratedClient != null) {
                this.decoratedClient.onApConnectionSuccessful(config);
            }
            ConnectToApFragment.this.clearState();
        }

        @Override
        public void onApConnectionFailed(WifiConfiguration config) {
            if (this.decoratedClient != null) {
                this.decoratedClient.onApConnectionFailed(config);
            }
            ConnectToApFragment.this.clearState();
        }

        void setDecoratedClient(Client decoratedClient) {
            this.decoratedClient = decoratedClient;
        }
    }

    private class WifiStateChangeLogger
    extends BroadcastReceiver {
        private WifiStateChangeLogger() {
        }

        public void onReceive(Context context, Intent intent) {
            log.d("Received android.net.wifi.STATE_CHANGE");
            log.d("EXTRA_NETWORK_INFO: " + intent.getParcelableExtra("networkInfo"));
            WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
            log.d("WIFI_INFO: " + wifiInfo);
        }

        IntentFilter buildIntentFilter() {
            return new IntentFilter("android.net.wifi.STATE_CHANGE");
        }
    }

    public static interface Client {
        public void onApConnectionSuccessful(WifiConfiguration var1);

        public void onApConnectionFailed(WifiConfiguration var1);
    }
}

