/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import io.particle.android.sdk.utils.EZ;

public class WaitForCloudConnectivityStep
extends SetupStep {
    private static final int MAX_RETRIES_REACHABILITY = 1;
    private final SparkCloud cloud;
    private final Context ctx;

    public WaitForCloudConnectivityStep(StepConfig stepConfig, SparkCloud cloud, Context ctx) {
        super(stepConfig);
        this.cloud = cloud;
        this.ctx = ctx;
    }

    @Override
    protected void onRunStep() throws SetupStepException {
        EZ.threadSleep((long)2000L);
        boolean isAPIHostReachable = this.checkIsApiHostAvailable();
        for (int reachabilityRetries = 0; !isAPIHostReachable && reachabilityRetries <= 1; ++reachabilityRetries) {
            EZ.threadSleep((long)2000L);
            isAPIHostReachable = this.checkIsApiHostAvailable();
            this.log.d("Checked for reachability " + reachabilityRetries + " times");
        }
        if (!isAPIHostReachable) {
            throw new SetupStepException("Unable to reach API host");
        }
    }

    @Override
    public boolean isStepFulfilled() {
        return this.checkIsApiHostAvailable();
    }

    private boolean checkIsApiHostAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.ctx.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = cm.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }
}

