/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.setupsteps;

import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ConnectAPCommand;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStep;
import io.particle.android.sdk.devicesetup.setupsteps.SetupStepException;
import io.particle.android.sdk.devicesetup.setupsteps.StepConfig;
import java.io.IOException;

public class ConnectDeviceToNetworkStep
extends SetupStep {
    private final CommandClient commandClient;
    private volatile boolean commandSent = false;

    public ConnectDeviceToNetworkStep(StepConfig stepConfig, CommandClient commandClient) {
        super(stepConfig);
        this.commandClient = commandClient;
    }

    @Override
    protected void onRunStep() throws SetupStepException {
        try {
            this.log.d("Sending connect-ap command");
            ConnectAPCommand.Response response = this.commandClient.sendCommandAndReturnResponse(new ConnectAPCommand(0), ConnectAPCommand.Response.class);
            if (!response.isOK()) {
                throw new SetupStepException("ConnectAPCommand returned non-zero response code: " + response.responseCode);
            }
            this.commandSent = true;
        }
        catch (IOException e) {
            throw new SetupStepException(e);
        }
    }

    @Override
    public boolean isStepFulfilled() {
        return this.commandSent;
    }
}

