/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.devicesetup.loaders;

import android.content.Context;
import android.support.v4.content.AsyncTaskLoader;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import io.particle.android.sdk.devicesetup.commands.CommandClient;
import io.particle.android.sdk.devicesetup.commands.ScanApCommand;
import io.particle.android.sdk.devicesetup.model.ScanAPCommandResult;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class ScanApCommandLoader
extends AsyncTaskLoader<Set<ScanAPCommandResult>> {
    private static final TLog log = TLog.get(ScanApCommandLoader.class);
    private final CommandClient commandClient;
    private final Set<ScanAPCommandResult> accumulatedResults = Py.set((Object[])new ScanAPCommandResult[0]);
    private static Function<ScanApCommand.Scan, ScanAPCommandResult> toWifiNetwork = new Function<ScanApCommand.Scan, ScanAPCommandResult>(){

        public ScanAPCommandResult apply(ScanApCommand.Scan input) {
            return new ScanAPCommandResult(input);
        }
    };

    public ScanApCommandLoader(Context context, CommandClient client) {
        super(context);
        this.commandClient = client;
    }

    protected void onStartLoading() {
        super.onStartLoading();
        this.forceLoad();
    }

    protected void onStopLoading() {
        this.cancelLoad();
    }

    public Set<ScanAPCommandResult> loadInBackground() {
        try {
            ScanApCommand.Response response = this.commandClient.sendCommandAndReturnResponse(new ScanApCommand(), ScanApCommand.Response.class);
            this.accumulatedResults.addAll((Collection<ScanAPCommandResult>)FluentIterable.from(response.getScans()).transform(toWifiNetwork).toSet());
            log.d("Latest accumulated scan results: " + this.accumulatedResults);
            return Py.set(this.accumulatedResults);
        }
        catch (IOException e) {
            log.e("Error running scan-ap command: ", (Throwable)e);
            return null;
        }
    }
}

