/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.accountsetup;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.view.View;
import android.widget.EditText;
import com.afollestad.materialdialogs.MaterialDialog;
import com.afollestad.materialdialogs.Theme;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;

public class PasswordResetActivity
extends AppCompatActivity {
    private static final TLog log = TLog.get(PasswordResetActivity.class);
    public static final String EXTRA_EMAIL = "EXTRA_EMAIL";
    private SparkCloud sparkCloud;
    private EditText emailView;
    private Async.AsyncApiWorker<SparkCloud, Void> resetTask = null;

    public static Intent buildIntent(Context context, String email) {
        Intent i = new Intent(context, PasswordResetActivity.class);
        if (Py.truthy((Object)email)) {
            i.putExtra(EXTRA_EMAIL, email);
        }
        return i;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_password_reset);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        this.sparkCloud = SparkCloud.get((Context)this);
        Ui.findView((FragmentActivity)this, R.id.action_cancel).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PasswordResetActivity.this.finish();
            }
        });
        this.emailView = (EditText)Ui.findView((FragmentActivity)this, R.id.email);
    }

    public void onPasswordResetClicked(View v) {
        String email = this.emailView.getText().toString();
        if (this.isEmailValid(email)) {
            this.performReset();
        } else {
            new MaterialDialog.Builder((Context)this).theme(Theme.LIGHT).positiveText((CharSequence)"OK").autoDismiss(true).title((CharSequence)"Reset password").content((CharSequence)"Please enter a valid email address.").dismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    PasswordResetActivity.this.emailView.requestFocus();
                }
            }).show();
        }
    }

    private void performReset() {
        ParticleUi.showSparkButtonProgress((FragmentActivity)this, R.id.action_reset_password, true);
        this.resetTask = Async.executeAsync((SparkCloud)this.sparkCloud, (Async.ApiWork)new Async.ApiWork<SparkCloud, Void>(){

            public Void callApi(SparkCloud sparkCloud) throws SparkCloudException {
                sparkCloud.requestPasswordReset(PasswordResetActivity.this.emailView.getText().toString());
                return null;
            }

            public void onTaskFinished() {
                PasswordResetActivity.this.resetTask = null;
                ParticleUi.showSparkButtonProgress((FragmentActivity)PasswordResetActivity.this, R.id.action_reset_password, false);
            }

            public void onSuccess(Void result) {
                PasswordResetActivity.this.onResetAttemptFinished("Instructions for how to reset your password will be sent to the provided email address.  Please check your email and continue according to instructions.");
            }

            public void onFailure(SparkCloudException error) {
                log.d("onFailed(): " + error.getMessage());
                PasswordResetActivity.this.onResetAttemptFinished("Could not find a user with supplied email address, please  check the address supplied or create a new user via the signup screen");
            }
        });
    }

    private void onResetAttemptFinished(String content) {
        new MaterialDialog.Builder((Context)this).theme(Theme.LIGHT).positiveText((CharSequence)"OK").autoDismiss(true).content((CharSequence)content).dismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                PasswordResetActivity.this.finish();
            }
        }).show();
    }

    private boolean isEmailValid(String email) {
        return Py.truthy((Object)email) && email.contains("@");
    }
}

