/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.accountsetup;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.CreateAccountActivity;
import io.particle.android.sdk.accountsetup.PasswordResetActivity;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.ui.NextActivitySelector;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Ui;
import io.particle.android.sdk.utils.ui.WebViewActivity;

public class LoginActivity
extends BaseActivity {
    private static final TLog log = TLog.get(LoginActivity.class);
    private Async.AsyncApiWorker<SparkCloud, Void> loginTask = null;
    private EditText emailView;
    private EditText passwordView;
    private SparkCloud sparkCloud;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_login);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        this.sparkCloud = SparkCloud.get((Context)this);
        this.emailView = (EditText)Ui.findView((FragmentActivity)this, R.id.email);
        this.passwordView = (EditText)Ui.findView((FragmentActivity)this, R.id.password);
        this.passwordView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int id2, KeyEvent keyEvent) {
                if (id2 == R.id.action_log_in || id2 == 0) {
                    LoginActivity.this.attemptLogin();
                    return true;
                }
                return false;
            }
        });
        for (EditText tv : Py.list((Object[])new EditText[]{this.emailView, this.passwordView})) {
            tv.addTextChangedListener(new TextWatcher(){

                public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
                }

                public void afterTextChanged(Editable editable) {
                    LoginActivity.this.emailView.setError(null);
                    LoginActivity.this.passwordView.setError(null);
                }
            });
        }
        Button submit = (Button)Ui.findView((FragmentActivity)this, R.id.action_log_in);
        submit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginActivity.this.attemptLogin();
            }
        });
        Ui.setText((FragmentActivity)this, R.id.log_in_header_text, Phrase.from((Context)this, (int)R.string.log_in_header_text).put("brand_name", (CharSequence)this.getString(R.string.brand_name)).format());
        Ui.setTextFromHtml((FragmentActivity)this, R.id.user_has_no_account, R.string.msg_no_account).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginActivity.this.startActivity(new Intent(v.getContext(), CreateAccountActivity.class));
                LoginActivity.this.finish();
            }
        });
        Ui.setTextFromHtml((FragmentActivity)this, R.id.forgot_password, R.string.msg_forgot_password);
    }

    public void onPasswordResetClicked(View v) {
        Intent intent = this.getResources().getBoolean(R.bool.organization) ? PasswordResetActivity.buildIntent((Context)this, this.emailView.getText().toString()) : WebViewActivity.buildIntent((Context)this, Uri.parse((String)this.getString(R.string.forgot_password_uri)));
        this.startActivity(intent);
    }

    public void attemptLogin() {
        if (this.loginTask != null) {
            log.wtf("Login being attempted again even though the button isn't enabled?!");
            return;
        }
        this.emailView.setError(null);
        this.passwordView.setError(null);
        final String email = this.emailView.getText().toString();
        final String password = this.passwordView.getText().toString();
        boolean cancel = false;
        EditText focusView = null;
        if (!TextUtils.isEmpty((CharSequence)password) && !this.isPasswordValid(password)) {
            this.passwordView.setError((CharSequence)this.getString(R.string.error_invalid_password));
            focusView = this.passwordView;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_field_required));
            focusView = this.emailView;
            cancel = true;
        } else if (!this.isEmailValid(email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_invalid_email));
            focusView = this.emailView;
            cancel = true;
        }
        if (cancel) {
            focusView.requestFocus();
        } else {
            ParticleUi.showSparkButtonProgress((FragmentActivity)this, R.id.action_log_in, true);
            this.loginTask = Async.executeAsync((SparkCloud)this.sparkCloud, (Async.ApiWork)new Async.ApiWork<SparkCloud, Void>(){

                public Void callApi(SparkCloud sparkCloud) throws SparkCloudException {
                    sparkCloud.logIn(email, password);
                    sparkCloud.getDevices();
                    return null;
                }

                public void onTaskFinished() {
                    LoginActivity.this.loginTask = null;
                }

                public void onSuccess(Void result) {
                    log.d("Logged in...");
                    if (LoginActivity.this.isFinishing()) {
                        return;
                    }
                    LoginActivity.this.startActivity(NextActivitySelector.getNextActivityIntent((Context)LoginActivity.this, LoginActivity.this.sparkCloud, SDKGlobals.getSensitiveDataStorage(), SDKGlobals.getAppDataStorage()));
                    LoginActivity.this.finish();
                }

                public void onFailure(SparkCloudException error) {
                    log.d("onFailed(): " + error.getMessage());
                    ParticleUi.showSparkButtonProgress((FragmentActivity)LoginActivity.this, R.id.action_log_in, false);
                    LoginActivity.this.passwordView.setError((CharSequence)error.getBestMessage());
                    LoginActivity.this.passwordView.requestFocus();
                }
            });
        }
    }

    private boolean isEmailValid(String email) {
        return Py.truthy((Object)email) && email.contains("@");
    }

    private boolean isPasswordValid(String password) {
        return password.length() > 0;
    }
}

