/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.accountsetup;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.Patterns;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.squareup.phrase.Phrase;
import io.particle.android.sdk.accountsetup.LoginActivity;
import io.particle.android.sdk.cloud.SDKGlobals;
import io.particle.android.sdk.cloud.SparkCloud;
import io.particle.android.sdk.cloud.SparkCloudException;
import io.particle.android.sdk.devicesetup.R;
import io.particle.android.sdk.ui.BaseActivity;
import io.particle.android.sdk.ui.NextActivitySelector;
import io.particle.android.sdk.utils.Async;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import io.particle.android.sdk.utils.ui.ParticleUi;
import io.particle.android.sdk.utils.ui.Toaster;
import io.particle.android.sdk.utils.ui.Ui;

public class CreateAccountActivity
extends BaseActivity {
    private static final TLog log = TLog.get(CreateAccountActivity.class);
    private Async.AsyncApiWorker<SparkCloud, Void> createAccountTask = null;
    private EditText emailView;
    private EditText passwordView;
    private EditText verifyPasswordView;
    private EditText activationCodeView;
    private boolean useOrganizationSignup;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_create_account);
        ParticleUi.enableBrandLogoInverseVisibilityAgainstSoftKeyboard((FragmentActivity)this);
        Ui.setText((FragmentActivity)this, R.id.create_account_header_text, Phrase.from((Context)this, (int)R.string.create_account_header_text).put("brand_name", (CharSequence)this.getString(R.string.brand_name)).format());
        this.emailView = (EditText)Ui.findView((FragmentActivity)this, R.id.email);
        this.passwordView = (EditText)Ui.findView((FragmentActivity)this, R.id.password);
        this.verifyPasswordView = (EditText)Ui.findView((FragmentActivity)this, R.id.verify_password);
        this.activationCodeView = (EditText)Ui.findView((FragmentActivity)this, R.id.activation_code);
        this.activationCodeView.setFilters(new InputFilter[]{new InputFilter.AllCaps(), new InputFilter.LengthFilter(4)});
        this.useOrganizationSignup = this.getResources().getBoolean(R.bool.organization);
        if (this.useOrganizationSignup) {
            Uri intentUri = this.getIntent().getData();
            if (intentUri != null) {
                this.activationCodeView.setText((CharSequence)intentUri.getQueryParameter("activation_code"));
            }
            this.activationCodeView.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                public boolean onEditorAction(TextView textView, int id2, KeyEvent keyEvent) {
                    if (id2 == R.id.action_log_in || id2 == 0) {
                        CreateAccountActivity.this.attemptCreateAccount();
                        return true;
                    }
                    return false;
                }
            });
        } else {
            this.activationCodeView.setVisibility(8);
        }
        Button submit = (Button)Ui.findView((FragmentActivity)this, R.id.action_create_account);
        submit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                CreateAccountActivity.this.attemptCreateAccount();
            }
        });
        Ui.setTextFromHtml((FragmentActivity)this, R.id.already_have_an_account_text, R.string.msg_user_already_has_account).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CreateAccountActivity.this.startActivity(new Intent(v.getContext(), LoginActivity.class));
                CreateAccountActivity.this.finish();
            }
        });
        if (this.getResources().getBoolean(R.bool.show_sign_up_page_fine_print)) {
            String tosUri = this.getString(R.string.terms_of_service_uri);
            String privacyPolicyUri = this.getString(R.string.privacy_policy_uri);
            String finePrintText = Phrase.from((Context)this, (int)R.string.msg_create_account_disclaimer).put("tos_link", (CharSequence)tosUri).put("privacy_policy_link", (CharSequence)privacyPolicyUri).format().toString();
            Ui.setTextFromHtml((FragmentActivity)this, R.id.fine_print, finePrintText).setMovementMethod(LinkMovementMethod.getInstance());
        } else {
            Ui.findView((FragmentActivity)this, R.id.fine_print).setVisibility(8);
        }
    }

    public void attemptCreateAccount() {
        if (this.createAccountTask != null) {
            log.wtf("Sign up being attempted again even though the sign up button isn't enabled?!");
            return;
        }
        this.emailView.setError(null);
        this.passwordView.setError(null);
        final String email = this.emailView.getText().toString();
        final String password = this.passwordView.getText().toString();
        final String activationCode = this.activationCodeView.getText().toString();
        boolean cancel = false;
        EditText focusView = null;
        if (!Py.truthy((Object)email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_field_required));
            focusView = this.emailView;
            cancel = true;
        } else if (!this.isEmailValid(email)) {
            this.emailView.setError((CharSequence)this.getString(R.string.error_invalid_email));
            focusView = this.emailView;
            cancel = true;
        }
        if (TextUtils.isEmpty((CharSequence)password)) {
            this.passwordView.setError((CharSequence)this.getString(R.string.error_field_required));
            focusView = this.passwordView;
            cancel = true;
        } else if (!this.isPasswordValid(password)) {
            this.passwordView.setError((CharSequence)this.getString(R.string.error_invalid_password));
            focusView = this.passwordView;
            cancel = true;
        } else if (!password.equals(this.verifyPasswordView.getText().toString())) {
            this.passwordView.setError((CharSequence)"Passwords do not match.");
            this.verifyPasswordView.setError((CharSequence)"Passwords do not match.");
            focusView = this.passwordView;
            cancel = true;
        }
        if (this.useOrganizationSignup) {
            if (!Py.truthy((Object)activationCode)) {
                this.activationCodeView.setError((CharSequence)this.getString(R.string.error_field_required));
                focusView = this.activationCodeView;
                cancel = true;
            } else if (!this.isActivationCodeValid(activationCode)) {
                this.activationCodeView.setError((CharSequence)this.getString(R.string.error_invalid_activation_code));
                focusView = this.activationCodeView;
                cancel = true;
            }
        }
        if (cancel) {
            focusView.requestFocus();
        } else {
            ParticleUi.showSparkButtonProgress((FragmentActivity)this, R.id.action_create_account, true);
            SparkCloud sparkCloud = SparkCloud.get((Context)this);
            this.createAccountTask = Async.executeAsync((SparkCloud)sparkCloud, (Async.ApiWork)new Async.ApiWork<SparkCloud, Void>(){

                public Void callApi(SparkCloud sparkCloud) throws SparkCloudException {
                    if (CreateAccountActivity.this.useOrganizationSignup) {
                        sparkCloud.signUpWithOrganization(email, password, activationCode, CreateAccountActivity.this.getString(R.string.organization_name));
                    } else {
                        sparkCloud.signUpWithUser(email, password);
                    }
                    return null;
                }

                public void onTaskFinished() {
                    CreateAccountActivity.this.createAccountTask = null;
                }

                public void onSuccess(Void result) {
                    log.d("onAccountCreated()!");
                    if (CreateAccountActivity.this.isFinishing()) {
                        return;
                    }
                    CreateAccountActivity.this.attemptLogin(email, password);
                }

                public void onFailure(SparkCloudException error) {
                    log.d("onFailed()");
                    ParticleUi.showSparkButtonProgress((FragmentActivity)CreateAccountActivity.this, R.id.action_create_account, false);
                    String msg = "Unknown error";
                    if (error.getKind() == SparkCloudException.Kind.NETWORK) {
                        msg = "Error communicating with server";
                    } else if (error.getResponseData() != null) {
                        msg = error.getResponseData().getHttpStatusCode() == 401 && CreateAccountActivity.this.getResources().getBoolean(R.bool.organization) ? "Make sure your user email does not already exist and that you have entered the activation code correctly and that it was not already used" : error.getServerErrorMsg();
                    }
                    Toaster.l((Context)CreateAccountActivity.this, msg, 16);
                    CreateAccountActivity.this.emailView.requestFocus();
                }
            });
        }
    }

    private boolean isEmailValid(String email) {
        return Patterns.EMAIL_ADDRESS.matcher(email).matches();
    }

    private boolean isPasswordValid(String password) {
        return password.length() > 0;
    }

    private boolean isActivationCodeValid(String activationCode) {
        return activationCode != null && activationCode.length() == 4;
    }

    private void attemptLogin(final String username, final String password) {
        final SparkCloud sparkCloud = SparkCloud.get((Context)this);
        Async.executeAsync((SparkCloud)sparkCloud, (Async.ApiWork)new Async.ApiWork<SparkCloud, Void>(){

            public Void callApi(SparkCloud sparkCloud2) throws SparkCloudException {
                sparkCloud2.logIn(username, password);
                return null;
            }

            public void onSuccess(Void result) {
                log.d("Logged in...");
                if (CreateAccountActivity.this.isFinishing()) {
                    return;
                }
                CreateAccountActivity.this.startActivity(NextActivitySelector.getNextActivityIntent((Context)CreateAccountActivity.this, sparkCloud, SDKGlobals.getSensitiveDataStorage(), SDKGlobals.getAppDataStorage()));
                CreateAccountActivity.this.finish();
            }

            public void onFailure(SparkCloudException error) {
                log.w("onFailed(): " + error.getMessage());
                ParticleUi.showSparkButtonProgress((FragmentActivity)CreateAccountActivity.this, R.id.action_create_account, false);
                CreateAccountActivity.this.passwordView.setError((CharSequence)error.getBestMessage());
                CreateAccountActivity.this.passwordView.requestFocus();
            }
        });
    }
}

