/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws.impl.url;

import java.net.URLStreamHandler;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.kaazing.net.URLStreamHandlerFactorySpi;
import org.kaazing.net.ws.impl.spi.WebSocketExtensionFactorySpi;
import org.kaazing.net.ws.impl.url.WsURLStreamHandlerImpl;

public class WsURLStreamHandlerFactorySpiImpl
extends URLStreamHandlerFactorySpi {
    private static final Collection<String> _supportedProtocols = Collections.unmodifiableList(Arrays.asList("ws", "wse", "wsn"));
    private static final Map<String, WebSocketExtensionFactorySpi> _extensionFactories;

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (!_supportedProtocols.contains(protocol)) {
            throw new IllegalArgumentException(String.format("Protocol not supported '%s'", protocol));
        }
        return new WsURLStreamHandlerImpl(_extensionFactories);
    }

    @Override
    public Collection<String> getSupportedProtocols() {
        return _supportedProtocols;
    }

    Map<String, WebSocketExtensionFactorySpi> getExtensionFactories() {
        return _extensionFactories;
    }

    static {
        Class<WebSocketExtensionFactorySpi> clazz = WebSocketExtensionFactorySpi.class;
        ServiceLoader<WebSocketExtensionFactorySpi> loader = ServiceLoader.load(clazz);
        HashMap<String, WebSocketExtensionFactorySpi> factories = new HashMap<String, WebSocketExtensionFactorySpi>();
        for (WebSocketExtensionFactorySpi factory : loader) {
            String extensionName = factory.getExtensionName();
            if (extensionName == null) continue;
            factories.put(extensionName, factory);
        }
        _extensionFactories = Collections.unmodifiableMap(factories);
    }
}

