/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wseb;

import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.CloseCommandMessage;
import org.kaazing.gateway.client.impl.ws.ReadyState;
import org.kaazing.gateway.client.impl.wseb.CreateChannel;
import org.kaazing.gateway.client.impl.wseb.CreateHandler;
import org.kaazing.gateway.client.impl.wseb.CreateHandlerFactory;
import org.kaazing.gateway.client.impl.wseb.CreateHandlerImpl;
import org.kaazing.gateway.client.impl.wseb.CreateHandlerListener;
import org.kaazing.gateway.client.impl.wseb.DownstreamChannel;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandler;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandlerFactory;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandlerImpl;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandlerListener;
import org.kaazing.gateway.client.impl.wseb.UpstreamChannel;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandler;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandlerFactory;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandlerImpl;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandlerListener;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedChannel;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketEmulatedHandler
extends WebSocketHandlerAdapter {
    static final String CLASS_NAME = WebSocketEmulatedHandler.class.getName();
    static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static final String HEADER_CONTENT_TYPE = "Content-Type";
    static final String HEADER_COOKIE = "Cookie";
    static final String HEADER_SET_COOKIE = "Set-Cookie";
    static final Charset UTF_8 = Charset.forName("UTF-8");
    static CreateHandlerFactory createHandlerFactory = CreateHandlerImpl.FACTORY;
    static DownstreamHandlerFactory downstreamHandlerFactory = DownstreamHandlerImpl.FACTORY;
    static UpstreamHandlerFactory upstreamHandlerFactory = UpstreamHandlerImpl.FACTORY;
    private final CreateHandler createHandler = createHandlerFactory.createCreateHandler();
    private final UpstreamHandler upstreamHandler = upstreamHandlerFactory.createUpstreamHandler();
    private final DownstreamHandler downstreamHandler = downstreamHandlerFactory.createDownstreamHandler();

    public WebSocketEmulatedHandler() {
        LOG.entering(CLASS_NAME, "<init>");
        this.initCreateHandler(this.createHandler);
        this.initUpstreamHandler(this.upstreamHandler);
        this.initDownstreamHandler(this.downstreamHandler);
    }

    void initCreateHandler(CreateHandler handler) {
        handler.setListener(new CreateHandlerListener(){

            @Override
            public void createCompleted(CreateChannel channel, HttpURI upstreamUri, HttpURI downstreamUri, String protocol) {
                LOG.entering(CLASS_NAME, "createCompleted");
                WebSocketEmulatedChannel parent = (WebSocketEmulatedChannel)channel.getParent();
                parent.createChannel = null;
                parent.setProtocol(protocol);
                long nextSequence = channel.nextSequence();
                UpstreamChannel upstreamChannel = new UpstreamChannel(upstreamUri, channel.cookie, nextSequence);
                upstreamChannel.setParent(parent);
                parent.upstreamChannel = upstreamChannel;
                DownstreamChannel downstreamChannel = new DownstreamChannel(downstreamUri, channel.cookie, nextSequence);
                downstreamChannel.setParent(parent);
                parent.downstreamChannel = downstreamChannel;
                parent.cookie = channel.cookie;
                WebSocketEmulatedHandler.this.downstreamHandler.processConnect(parent.downstreamChannel, downstreamUri);
                WebSocketEmulatedHandler.this.listener.connectionOpened(parent, protocol);
            }

            @Override
            public void createFailed(CreateChannel channel, Exception exception) {
                LOG.entering(CLASS_NAME, "createFailed");
                WebSocketEmulatedChannel parent = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.connectionFailed(parent, exception);
            }
        });
    }

    void initUpstreamHandler(UpstreamHandler handler) {
        handler.setListener(new UpstreamHandlerListener(){

            @Override
            public void upstreamCompleted(UpstreamChannel channel) {
            }

            @Override
            public void upstreamFailed(UpstreamChannel channel, Exception exception) {
                if (channel == null || channel.parent == null) {
                    throw new IllegalStateException("WebSocket upstream channel already closed");
                }
                WebSocketEmulatedChannel parent = channel.parent;
                parent.upstreamChannel = null;
                WebSocketEmulatedHandler.this.doError(parent, exception);
            }
        });
    }

    void initDownstreamHandler(DownstreamHandler handler) {
        handler.setListener(new DownstreamHandlerListener(){

            @Override
            public void downstreamOpened(DownstreamChannel channel) {
            }

            @Override
            public void binaryMessageReceived(DownstreamChannel channel, WrappedByteBuffer data) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.binaryMessageReceived(wsebChannel, data);
            }

            @Override
            public void textMessageReceived(DownstreamChannel channel, String text) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.listener.textMessageReceived(wsebChannel, text);
            }

            @Override
            public void downstreamFailed(DownstreamChannel channel, Exception exception) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.doError(wsebChannel, exception);
            }

            @Override
            public void downstreamClosed(DownstreamChannel channel) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.doClose(wsebChannel);
            }

            @Override
            public void commandMessageReceived(DownstreamChannel channel, CommandMessage message) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                if (message instanceof CloseCommandMessage) {
                    CloseCommandMessage msg = (CloseCommandMessage)message;
                    wsebChannel.wasCleanClose = true;
                    wsebChannel.closeCode = msg.getCode();
                    wsebChannel.closeReason = msg.getReason();
                    if (wsebChannel.getReadyState() == ReadyState.OPEN) {
                        WebSocketEmulatedHandler.this.upstreamHandler.processClose(wsebChannel.upstreamChannel, msg.getCode(), msg.getReason());
                    }
                }
                WebSocketEmulatedHandler.this.listener.commandMessageReceived(wsebChannel, message);
            }

            @Override
            public void pingReceived(DownstreamChannel channel) {
                WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel.getParent();
                WebSocketEmulatedHandler.this.upstreamHandler.processPong(wsebChannel.upstreamChannel);
            }
        });
    }

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI location, String[] protocols) {
        LOG.entering(CLASS_NAME, "connect", channel);
        String path = location.getPath();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        try {
            CreateChannel createChannel = new CreateChannel();
            createChannel.setParent(channel);
            createChannel.setProtocols(protocols);
            HttpURI createUri = (HttpURI)HttpURI.replaceScheme(location, location.getHttpEquivalentScheme()).replacePath(path + "/;e/cbm");
            this.createHandler.processOpen(createChannel, createUri);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.connectionFailed(channel, e);
        }
    }

    @Override
    public synchronized void processClose(WebSocketChannel channel, int code, String reason) {
        LOG.entering(CLASS_NAME, "processDisconnect");
        WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel;
        wsebChannel.closeCode = code;
        wsebChannel.closeReason = reason;
        this.upstreamHandler.processClose(wsebChannel.upstreamChannel, code, reason);
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String message) {
        LOG.entering(CLASS_NAME, "processTextMessage", message);
        WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel;
        this.upstreamHandler.processTextMessage(wsebChannel.upstreamChannel, message);
    }

    @Override
    public void processBinaryMessage(WebSocketChannel channel, WrappedByteBuffer message) {
        LOG.entering(CLASS_NAME, "processBinaryMessage", message);
        WebSocketEmulatedChannel wsebChannel = (WebSocketEmulatedChannel)channel;
        this.upstreamHandler.processBinaryMessage(wsebChannel.upstreamChannel, message);
    }

    private void doError(WebSocketEmulatedChannel channel, Exception exception) {
        LOG.entering(CLASS_NAME, "Error handler. Tearing down WebSocket connection.");
        try {
            if (channel.createChannel != null) {
                this.createHandler.processClose(channel.createChannel);
            }
            if (channel.downstreamChannel != null) {
                this.downstreamHandler.processClose(channel.downstreamChannel);
            }
        }
        catch (Exception e) {
            LOG.entering(CLASS_NAME, "Exception while tearing down the connection: " + e.getMessage());
        }
        LOG.entering(CLASS_NAME, "Firing Close Event");
        try {
            this.listener.connectionFailed(channel, exception);
        }
        catch (Exception e) {
            LOG.entering(CLASS_NAME, "Unhandled exception in Close Event: " + e.getMessage());
        }
    }

    private void doClose(WebSocketEmulatedChannel channel) {
        LOG.entering(CLASS_NAME, "Close");
        try {
            if (channel.createChannel != null) {
                this.createHandler.processClose(channel.createChannel);
            }
            if (channel.downstreamChannel != null) {
                this.downstreamHandler.processClose(channel.downstreamChannel);
            }
        }
        catch (Exception e) {
            LOG.entering(CLASS_NAME, "While closing: " + e.getMessage());
        }
        LOG.entering(CLASS_NAME, "Firing Close Event");
        try {
            channel.wasCleanClose = true;
            if (channel.closeCode == 0) {
                channel.closeCode = 1005;
            }
            this.listener.connectionClosed(channel, channel.wasCleanClose, channel.closeCode, channel.closeReason);
        }
        catch (Exception e) {
            LOG.entering(CLASS_NAME, "Unhandled exception in Close Event: " + e.getMessage());
        }
    }
}

