/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wseb;

import java.nio.charset.Charset;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.DecoderInput;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedDecoder;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedDecoderListener;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketEmulatedDecoderImpl<C>
implements WebSocketEmulatedDecoder<C> {
    private static final String CLASS_NAME = WebSocketEmulatedDecoderImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final byte WSF_COMMAND_FRAME_START = 1;
    private static final byte WS_TEXT_FRAME_END = -1;
    private static final byte WS_BINARY_FRAME_START = -128;
    private static final byte WS_SPECIFIEDLENGTH_TEXT_FRAME_START = -127;
    private static final byte WSE_PING_FRAME_CODE = -119;
    private DecodingState processingState = DecodingState.START_OF_FRAME;
    private WrappedByteBuffer readBuffer = null;
    private WrappedByteBuffer messageBuffer = null;
    private int binaryFrameLength = 0;
    private byte opCode = 0;

    @Override
    public void decode(C channel, DecoderInput<C> in, WebSocketEmulatedDecoderListener<C> listener) {
        LOG.fine("process() START");
        block0: while (true) {
            if (this.readBuffer == null) {
                this.readBuffer = in.read(channel);
                if (this.readBuffer == null) break;
            }
            if (!this.readBuffer.hasRemaining()) {
                this.readBuffer = null;
                continue;
            }
            if (this.processingState == DecodingState.START_OF_FRAME) {
                this.opCode = this.readBuffer.get();
                if (this.opCode == 1) {
                    this.processingState = DecodingState.READING_COMMAND_FRAME;
                    this.messageBuffer = WrappedByteBuffer.allocate(512);
                    continue;
                }
                if (this.opCode == -119) {
                    this.processingState = DecodingState.READING_PING_FRAME;
                    continue;
                }
                if (this.opCode != -128 && this.opCode != -127) continue;
                this.processingState = DecodingState.READING_BINARY_FRAME_HEADER;
                this.binaryFrameLength = 0;
                continue;
            }
            if (this.processingState == DecodingState.READING_COMMAND_FRAME) {
                int endOfFrameAt = this.readBuffer.indexOf((byte)-1);
                if (endOfFrameAt == -1) {
                    int numBytes = this.readBuffer.remaining();
                    this.messageBuffer.putBuffer(this.readBuffer);
                    continue;
                }
                int dataLength = endOfFrameAt - this.readBuffer.position();
                this.messageBuffer.putBytes(this.readBuffer.getBytes(dataLength));
                this.readBuffer.skip(1);
                boolean isCommandFrame = this.processingState == DecodingState.READING_COMMAND_FRAME;
                this.processingState = DecodingState.START_OF_FRAME;
                if (isCommandFrame) {
                    this.messageBuffer.flip();
                    if (this.messageBuffer.array()[0] == 48 && this.messageBuffer.array()[1] == 48) continue;
                    listener.commandDecoded(channel, this.messageBuffer.duplicate());
                    continue;
                }
                this.messageBuffer.flip();
                String text = this.messageBuffer.getString(UTF8);
                listener.messageDecoded(channel, text);
                continue;
            }
            if (this.processingState == DecodingState.READING_BINARY_FRAME_HEADER) {
                byte b;
                do {
                    if (!this.readBuffer.hasRemaining()) continue block0;
                    b = this.readBuffer.get();
                    this.binaryFrameLength <<= 7;
                    this.binaryFrameLength |= b & 0x7F;
                } while ((b & 0x80) == 128);
                this.processingState = DecodingState.READING_BINARY_FRAME;
                this.messageBuffer = WrappedByteBuffer.allocate(this.binaryFrameLength);
                continue;
            }
            if (this.processingState == DecodingState.READING_BINARY_FRAME) {
                if (this.readBuffer.remaining() < this.binaryFrameLength) {
                    int numbytes = this.readBuffer.remaining();
                    this.messageBuffer.putBuffer(this.readBuffer);
                    this.binaryFrameLength -= numbytes;
                    continue;
                }
                this.messageBuffer.putBytes(this.readBuffer.getBytes(this.binaryFrameLength));
                this.processingState = DecodingState.START_OF_FRAME;
                this.messageBuffer.flip();
                if (this.opCode == -127) {
                    String text = this.messageBuffer.getString(UTF8);
                    listener.messageDecoded(channel, text);
                    continue;
                }
                if (this.opCode == -128) {
                    listener.messageDecoded(channel, this.messageBuffer);
                    continue;
                }
                throw new IllegalArgumentException("Invalid frame opcode. opcode = " + this.opCode);
            }
            if (this.processingState != DecodingState.READING_PING_FRAME) continue;
            byte byteFollowingPingFrameCode = this.readBuffer.get();
            this.processingState = DecodingState.START_OF_FRAME;
            if (byteFollowingPingFrameCode != 0) {
                throw new IllegalArgumentException("Expected 0x00 after the PING frame code but received - " + byteFollowingPingFrameCode);
            }
            listener.pingReceived(channel);
        }
    }

    static enum DecodingState {
        START_OF_FRAME,
        READING_TEXT_FRAME,
        READING_COMMAND_FRAME,
        READING_BINARY_FRAME_HEADER,
        READING_BINARY_FRAME,
        READING_PING_FRAME;

    }
}

