/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.bridge;

import java.io.Serializable;
import java.util.logging.Logger;

public class XoaEvent
implements Serializable {
    private static final String CLASS_NAME = XoaEvent.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final long serialVersionUID = 1L;
    public static final String[] EMPTY_ARGS = new String[0];
    private Integer handlerId;
    private XoaEventKind kind;
    private Object[] params;

    public XoaEvent(Integer handlerId, XoaEventKind event, Object[] params) {
        LOG.entering(CLASS_NAME, "<init>", new Object[]{handlerId, event, params});
        this.handlerId = handlerId;
        this.kind = event;
        this.params = params;
    }

    public Integer getHandlerId() {
        LOG.exiting(CLASS_NAME, "getHandlerId", this.handlerId);
        return this.handlerId;
    }

    public XoaEventKind getKind() {
        LOG.exiting(CLASS_NAME, "getEvent", (Object)this.kind);
        return this.kind;
    }

    public Object[] getParams() {
        LOG.exiting(CLASS_NAME, "getParams", this.params);
        return this.params;
    }

    public String toString() {
        StringBuilder out = new StringBuilder("EventID:" + this.getHandlerId() + "," + this.getKind().name() + "[");
        for (Object param : this.params) {
            out.append(param).append(",");
        }
        return out + "]";
    }

    public static enum XoaEventKind {
        OPEN("open"),
        MESSAGE("message"),
        CLOSED("closed"),
        REDIRECT("redirect"),
        AUTHENTICATE("authenticate"),
        AUTHORIZE("authorize"),
        LOAD("load"),
        PROGRESS("progress"),
        READYSTATECHANGE("readystatechange"),
        ERROR("error"),
        ABORT("abort"),
        CREATE("create"),
        POSTMESSAGE("postMessage"),
        DISCONNECT("disconnect"),
        SEND("send"),
        GETRESPONSEHEADER("getResponseHeader"),
        GEALLRESPONSEHEADERS("getAllResponseHeaders"),
        SETREQUESTHEADER("setRequestHeader"),
        UNDEFINED("");

        String name;

        private XoaEventKind(String in) {
            this.name = in;
        }

        public static XoaEventKind getName(String in) {
            XoaEventKind[] v;
            for (XoaEventKind aV : v = XoaEventKind.values()) {
                if (!aV.name.equals(in)) continue;
                return aV;
            }
            return UNDEFINED;
        }

        public String toString() {
            return this.name;
        }
    }
}

