/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.bridge;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.bridge.BridgeUtil;
import org.kaazing.gateway.client.impl.bridge.Proxy;
import org.kaazing.gateway.client.impl.bridge.ProxyListener;
import org.kaazing.gateway.client.impl.bridge.XoaEvent;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeChannel;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketNativeBridgeHandler
implements WebSocketHandler,
ProxyListener {
    private static final String CLASS_NAME = WebSocketNativeBridgeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private WebSocketHandlerListener listener;

    public WebSocketNativeBridgeHandler() {
        LOG.entering(CLASS_NAME, "<init>");
    }

    @Override
    public synchronized void processConnect(WebSocketChannel channel, WSURI uri, String[] protocols) {
        LOG.entering(CLASS_NAME, "processConnect", new Object[]{uri, protocols});
        try {
            Object[] params;
            WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
            if (nativeChannel.getProxy() != null) {
                throw new IllegalStateException("Bridge proxy previously set");
            }
            Proxy proxy = BridgeUtil.createProxy(uri.getURI(), this);
            proxy.setPeer(channel);
            nativeChannel.setProxy(proxy);
            if (protocols != null) {
                StringBuilder s = new StringBuilder();
                for (int i = 0; i < protocols.length; ++i) {
                    if (i > 0) {
                        s.append(",");
                    }
                    s.append(protocols[i]);
                }
                params = new String[]{"WEBSOCKET", uri.toString(), s.toString(), ""};
            } else {
                params = new String[]{"WEBSOCKET", uri.toString()};
            }
            proxy.processEvent(XoaEvent.XoaEventKind.CREATE, params);
        }
        catch (Exception e) {
            LOG.log(Level.FINE, "While initializing WebSocket proxy: " + e.getMessage(), e);
            this.listener.connectionFailed(channel, e);
        }
    }

    @Override
    public void processAuthorize(WebSocketChannel channel, String authorizeToken) {
        LOG.entering(CLASS_NAME, "processAuthorize");
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.AUTHORIZE, new String[]{authorizeToken});
    }

    @Override
    public void processTextMessage(WebSocketChannel channel, String text) {
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.POSTMESSAGE, new Object[]{text});
    }

    @Override
    public void processBinaryMessage(WebSocketChannel channel, WrappedByteBuffer message) {
        ByteBuffer buffer = ByteBuffer.allocate(message.remaining());
        buffer.put(message.array(), message.arrayOffset(), message.remaining());
        buffer.flip();
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.POSTMESSAGE, new Object[]{buffer});
    }

    @Override
    public synchronized void processClose(WebSocketChannel channel, int code, String reason) {
        LOG.entering(CLASS_NAME, "processDisconnect");
        WebSocketNativeChannel nativeChannel = (WebSocketNativeChannel)channel;
        Proxy proxy = nativeChannel.getProxy();
        proxy.processEvent(XoaEvent.XoaEventKind.DISCONNECT, new String[0]);
    }

    @Override
    public final void eventReceived(Proxy proxy, XoaEvent.XoaEventKind eventKind, Object[] params) {
        LOG.entering(CLASS_NAME, "eventReceived", new Object[]{proxy.getHandlerId(), eventKind, params});
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "SOA <-- XOA:id = " + proxy + " name: " + (Object)((Object)eventKind));
        }
        WebSocketNativeChannel channel = (WebSocketNativeChannel)proxy.getPeer();
        switch (eventKind) {
            case OPEN: {
                String protocol = (String)params[0];
                this.listener.connectionOpened(channel, protocol);
                break;
            }
            case CLOSED: {
                channel.setProxy(null);
                this.listener.connectionClosed(channel, false, 1006, "");
                break;
            }
            case REDIRECT: {
                String redirectUrl = (String)params[0];
                this.listener.redirected(channel, redirectUrl);
                break;
            }
            case AUTHENTICATE: {
                String location = channel.getLocation().toString();
                String challenge = (String)params[0];
                this.listener.authenticationRequested(channel, location, challenge);
                break;
            }
            case MESSAGE: {
                String messageType;
                WrappedByteBuffer messageBuffer = WrappedByteBuffer.wrap((ByteBuffer)params[0]);
                String string2 = messageType = params.length > 1 ? (String)params[1] : null;
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, messageBuffer.getHexDump());
                }
                if (messageType == null) {
                    LOG.severe("Incompatible bridge detected");
                    this.listener.connectionFailed(channel, new IllegalStateException("Incompatible bridge detected"));
                }
                if ("TEXT".equals(messageType)) {
                    String text = messageBuffer.getString(UTF8);
                    this.listener.textMessageReceived(channel, text);
                    break;
                }
                this.listener.binaryMessageReceived(channel, messageBuffer);
                break;
            }
            case ERROR: {
                this.listener.connectionFailed(channel, new IllegalStateException("ERROR event in the native bridge handler"));
            }
        }
    }

    @Override
    public void setListener(WebSocketHandlerListener listener) {
        this.listener = listener;
    }

    @Override
    public void setIdleTimeout(WebSocketChannel channel, int timeout) {
    }
}

