/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.MainThread;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.DeviceState;
import io.particle.android.sdk.cloud.FunctionArgs;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.ParticleCloudSDK;
import io.particle.android.sdk.cloud.ParticleEvent;
import io.particle.android.sdk.cloud.ParticleEventHandler;
import io.particle.android.sdk.cloud.Responses;
import io.particle.android.sdk.cloud.SDKProvider;
import io.particle.android.sdk.cloud.SimpleParticleEventHandler;
import io.particle.android.sdk.cloud.exceptions.ParticleCloudException;
import io.particle.android.sdk.cloud.models.DeviceStateChange;
import io.particle.android.sdk.utils.ParticleInternalStringUtils;
import io.particle.android.sdk.utils.Preconditions;
import io.particle.android.sdk.utils.Py;
import io.particle.android.sdk.utils.TLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import okio.Okio;
import okio.Source;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit.RetrofitError;
import retrofit.client.Response;
import retrofit.mime.TypedByteArray;
import retrofit.mime.TypedFile;
import retrofit.mime.TypedOutput;

@ParametersAreNonnullByDefault
@SuppressLint(value={"DefaultLocale"})
public class ParticleDevice
implements Parcelable {
    private static final int MAX_PARTICLE_FUNCTION_ARG_LENGTH = 63;
    private static final TLog log = TLog.get(ParticleDevice.class);
    private final CopyOnWriteArrayList<Long> subscriptions = new CopyOnWriteArrayList();
    private final ApiDefs.CloudApi mainApi;
    private final ParticleCloud cloud;
    volatile DeviceState deviceState;
    private volatile boolean isFlashing = false;
    public static final Parcelable.Creator<ParticleDevice> CREATOR = new Parcelable.Creator<ParticleDevice>(){

        public ParticleDevice createFromParcel(Parcel in) {
            SDKProvider sdkProvider = ParticleCloudSDK.getSdkProvider();
            DeviceState deviceState = (DeviceState)in.readParcelable(DeviceState.class.getClassLoader());
            return sdkProvider.getParticleCloud().getDeviceFromState(deviceState);
        }

        public ParticleDevice[] newArray(int size) {
            return new ParticleDevice[size];
        }
    };

    ParticleDevice(ApiDefs.CloudApi mainApi, ParticleCloud cloud, DeviceState deviceState) {
        this.mainApi = mainApi;
        this.cloud = cloud;
        this.deviceState = deviceState;
    }

    public String getID() {
        return this.deviceState.deviceId;
    }

    public String getName() {
        return this.deviceState.name;
    }

    public void setName(String newName) throws ParticleCloudException {
        this.cloud.rename(this.deviceState.deviceId, newName);
    }

    public boolean isConnected() {
        return this.deviceState.isConnected;
    }

    public Set<String> getFunctions() {
        return this.deviceState.functions;
    }

    public Map<String, VariableType> getVariables() {
        return this.deviceState.variables;
    }

    public String getVersion() {
        return this.deviceState.version;
    }

    public boolean requiresUpdate() {
        return this.deviceState.requiresUpdate;
    }

    public ParticleDeviceType getDeviceType() {
        return this.deviceState.deviceType;
    }

    public int getPlatformID() {
        return this.deviceState.platformId;
    }

    public int getProductID() {
        return this.deviceState.productId;
    }

    public boolean isCellular() {
        return this.deviceState.cellular;
    }

    public String getImei() {
        return this.deviceState.imei;
    }

    public String getIccid() {
        return this.deviceState.lastIccid;
    }

    public String getCurrentBuild() {
        return this.deviceState.currentBuild;
    }

    public String getDefaultBuild() {
        return this.deviceState.defaultBuild;
    }

    public String getIpAddress() {
        return this.deviceState.ipAddress;
    }

    public String getLastAppName() {
        return this.deviceState.lastAppName;
    }

    public String getStatus() {
        return this.deviceState.status;
    }

    public Date getLastHeard() {
        return this.deviceState.lastHeard;
    }

    @WorkerThread
    public float getCurrentDataUsage() throws ParticleCloudException {
        float maxUsage = 0.0f;
        try {
            Response response = this.mainApi.getCurrentDataUsage(this.deviceState.lastIccid);
            JSONObject result = new JSONObject(new String(((TypedByteArray)response.getBody()).getBytes()));
            JSONArray usages = result.getJSONArray("usage_by_day");
            for (int i = 0; i < usages.length(); ++i) {
                double usage;
                JSONObject usageElement = usages.getJSONObject(i);
                if (!usageElement.has("mbs_used_cumulative") || !((usage = usageElement.getDouble("mbs_used_cumulative")) > (double)maxUsage)) continue;
                maxUsage = (float)usage;
            }
        }
        catch (JSONException | RetrofitError e) {
            throw new ParticleCloudException((Exception)e);
        }
        return maxUsage;
    }

    @WorkerThread
    public Object getVariable(String variableName) throws ParticleCloudException, IOException, VariableDoesNotExistException {
        VariableRequester<Object, Responses.ReadObjectVariableResponse> requester = new VariableRequester<Object, Responses.ReadObjectVariableResponse>(this){

            @Override
            Responses.ReadObjectVariableResponse callApi(String variableName) {
                return ParticleDevice.this.mainApi.getVariable(ParticleDevice.this.deviceState.deviceId, variableName);
            }
        };
        return requester.getVariable(variableName);
    }

    @WorkerThread
    public int getIntVariable(String variableName) throws ParticleCloudException, IOException, VariableDoesNotExistException, ClassCastException {
        VariableRequester<Integer, Responses.ReadIntVariableResponse> requester = new VariableRequester<Integer, Responses.ReadIntVariableResponse>(this){

            @Override
            Responses.ReadIntVariableResponse callApi(String variableName) {
                return ParticleDevice.this.mainApi.getIntVariable(ParticleDevice.this.deviceState.deviceId, variableName);
            }
        };
        return (Integer)requester.getVariable(variableName);
    }

    @WorkerThread
    public String getStringVariable(String variableName) throws ParticleCloudException, IOException, VariableDoesNotExistException, ClassCastException {
        VariableRequester<String, Responses.ReadStringVariableResponse> requester = new VariableRequester<String, Responses.ReadStringVariableResponse>(this){

            @Override
            Responses.ReadStringVariableResponse callApi(String variableName) {
                return ParticleDevice.this.mainApi.getStringVariable(ParticleDevice.this.deviceState.deviceId, variableName);
            }
        };
        return (String)requester.getVariable(variableName);
    }

    @WorkerThread
    public double getDoubleVariable(String variableName) throws ParticleCloudException, IOException, VariableDoesNotExistException, ClassCastException {
        VariableRequester<Double, Responses.ReadDoubleVariableResponse> requester = new VariableRequester<Double, Responses.ReadDoubleVariableResponse>(this){

            @Override
            Responses.ReadDoubleVariableResponse callApi(String variableName) {
                return ParticleDevice.this.mainApi.getDoubleVariable(ParticleDevice.this.deviceState.deviceId, variableName);
            }
        };
        return (Double)requester.getVariable(variableName);
    }

    @WorkerThread
    public int callFunction(String functionName, @Nullable List<String> args) throws ParticleCloudException, IOException, FunctionDoesNotExistException {
        Responses.CallFunctionResponse response;
        String argsString;
        if (!this.deviceState.functions.contains(functionName)) {
            throw new FunctionDoesNotExistException(functionName);
        }
        if (args == null) {
            args = Py.list();
        }
        Preconditions.checkArgument((argsString = ParticleInternalStringUtils.join(args, ',')).length() < 63, String.format("Arguments '%s' exceed max args length of %d", argsString, 63));
        try {
            response = this.mainApi.callFunction(this.deviceState.deviceId, functionName, new FunctionArgs(argsString));
        }
        catch (RetrofitError e) {
            throw new ParticleCloudException((Exception)((Object)e));
        }
        if (!response.connected) {
            this.cloud.onDeviceNotConnected(this.deviceState);
            throw new IOException("Device is not connected.");
        }
        return response.returnValue;
    }

    @WorkerThread
    public int callFunction(String functionName) throws ParticleCloudException, IOException, FunctionDoesNotExistException {
        return this.callFunction(functionName, null);
    }

    public long subscribeToEvents(@Nullable String eventNamePrefix, ParticleEventHandler handler) throws IOException {
        return this.cloud.subscribeToDeviceEvents(eventNamePrefix, this.deviceState.deviceId, handler);
    }

    public void unsubscribeFromEvents(long eventListenerID) throws ParticleCloudException {
        this.cloud.unsubscribeFromEventWithID(eventListenerID);
    }

    @WorkerThread
    public void unclaim() throws ParticleCloudException {
        try {
            this.cloud.unclaimDevice(this.deviceState.deviceId);
        }
        catch (RetrofitError e) {
            throw new ParticleCloudException((Exception)((Object)e));
        }
    }

    public boolean isRunningTinker() {
        List lowercaseFunctions = Py.list();
        for (String func : this.deviceState.functions) {
            lowercaseFunctions.add(func.toLowerCase());
        }
        List<String> tinkerFunctions = Py.list("analogread", "analogwrite", "digitalread", "digitalwrite");
        return this.isConnected() && lowercaseFunctions.containsAll(tinkerFunctions);
    }

    public boolean isFlashing() {
        return this.isFlashing;
    }

    @WorkerThread
    public void flashKnownApp(KnownApp knownApp) throws ParticleCloudException {
        this.performFlashingChange(() -> this.mainApi.flashKnownApp(this.deviceState.deviceId, knownApp.appName));
    }

    @WorkerThread
    public void flashBinaryFile(File file) throws ParticleCloudException {
        this.performFlashingChange(() -> this.mainApi.flashFile(this.deviceState.deviceId, (TypedOutput)new TypedFile("application/octet-stream", file)));
    }

    @WorkerThread
    public void flashBinaryFile(InputStream stream) throws ParticleCloudException, IOException {
        byte[] bytes = Okio.buffer((Source)Okio.source((InputStream)stream)).readByteArray();
        this.performFlashingChange(() -> this.mainApi.flashFile(this.deviceState.deviceId, (TypedOutput)new TypedFakeFile(bytes)));
    }

    @WorkerThread
    public void flashCodeFile(File file) throws ParticleCloudException {
        this.performFlashingChange(() -> this.mainApi.flashFile(this.deviceState.deviceId, (TypedOutput)new TypedFile("multipart/form-data", file)));
    }

    @WorkerThread
    public void flashCodeFile(InputStream stream) throws ParticleCloudException, IOException {
        byte[] bytes = Okio.buffer((Source)Okio.source((InputStream)stream)).readByteArray();
        this.performFlashingChange(() -> this.mainApi.flashFile(this.deviceState.deviceId, (TypedOutput)new TypedFakeFile(bytes, "multipart/form-data", "code.ino")));
    }

    public ParticleCloud getCloud() {
        return this.cloud;
    }

    @WorkerThread
    public void refresh() throws ParticleCloudException {
        this.cloud.getDevice(this.deviceState.deviceId);
    }

    private void performFlashingChange(FlashingChange flashingChange) throws ParticleCloudException {
        try {
            flashingChange.executeFlashingChange();
            this.subscribeToSystemEvent("spark/flash/status", new SimpleParticleEventHandler(){

                @Override
                public void onEvent(String eventName, ParticleEvent particleEvent) {
                    if ("success".equals(particleEvent.dataPayload)) {
                        ParticleDevice.this.isFlashing = false;
                        try {
                            ParticleDevice.this.refresh();
                            ParticleDevice.this.cloud.unsubscribeFromEventWithHandler(this);
                        }
                        catch (ParticleCloudException e) {
                            log.w("Unable to reset flashing state for %s" + ParticleDevice.this.deviceState.deviceId, e);
                        }
                    } else {
                        ParticleDevice.this.isFlashing = true;
                    }
                    ParticleDevice.this.cloud.notifyDeviceChanged();
                }
            });
        }
        catch (IOException | RetrofitError e) {
            throw new ParticleCloudException((Exception)e);
        }
    }

    @MainThread
    public void subscribeToSystemEvents() throws ParticleCloudException {
        try {
            EventBus eventBus = EventBus.getDefault();
            this.subscriptions.add(this.subscribeToSystemEvent("spark/status", (eventName, particleEvent) -> this.sendUpdateStatusChange(eventBus, particleEvent.dataPayload)));
            this.subscriptions.add(this.subscribeToSystemEvent("spark/flash/status", (eventName, particleEvent) -> this.sendUpdateFlashChange(eventBus, particleEvent.dataPayload)));
            this.subscriptions.add(this.subscribeToSystemEvent("spark/device/app-hash", (eventName, particleEvent) -> this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.APP_HASH_UPDATED), eventBus)));
            this.subscriptions.add(this.subscribeToSystemEvent("spark/status/safe-mode", (eventName, particleEvent) -> this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.SAFE_MODE_UPDATER), eventBus)));
            this.subscriptions.add(this.subscribeToSystemEvent("spark/safe-mode-updater/updating", (eventName, particleEvent) -> this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.ENTERED_SAFE_MODE), eventBus)));
        }
        catch (IOException e) {
            log.d("Failed to auto-subscribe to system events");
            throw new ParticleCloudException(e);
        }
    }

    private void sendSystemEventBroadcast(DeviceStateChange deviceStateChange, EventBus eventBus) {
        this.cloud.sendSystemEventBroadcast(deviceStateChange);
        eventBus.post((Object)deviceStateChange);
    }

    public void unsubscribeFromSystemEvents() throws ParticleCloudException {
        for (Long subscriptionId : this.subscriptions) {
            this.unsubscribeFromEvents(subscriptionId);
        }
    }

    private long subscribeToSystemEvent(String eventNamePrefix, final SimpleParticleEventHandler particleEventHandler) throws IOException {
        return this.subscribeToEvents(eventNamePrefix, new ParticleEventHandler(){

            @Override
            public void onEvent(String eventName, ParticleEvent particleEvent) {
                particleEventHandler.onEvent(eventName, particleEvent);
            }

            @Override
            public void onEventError(Exception e) {
                log.d("Event error in system event handler");
            }
        });
    }

    private void sendUpdateStatusChange(EventBus eventBus, String data) {
        Object deviceStateChange = null;
        switch (data) {
            case "online": {
                this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.CAME_ONLINE), eventBus);
                break;
            }
            case "offline": {
                this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.WENT_OFFLINE), eventBus);
            }
        }
    }

    private void sendUpdateFlashChange(EventBus eventBus, String data) {
        Object deviceStateChange = null;
        switch (data) {
            case "started": {
                this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.FLASH_STARTED), eventBus);
                break;
            }
            case "success": {
                this.sendSystemEventBroadcast(new DeviceStateChange(this, ParticleDeviceState.FLASH_SUCCEEDED), eventBus);
            }
        }
    }

    public String toString() {
        return "ParticleDevice{deviceId=" + this.deviceState.deviceId + ", isConnected=" + this.deviceState.isConnected + ", deviceType=" + (Object)((Object)this.deviceState.deviceType) + '}';
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable((Parcelable)this.deviceState, flags);
    }

    public int describeContents() {
        return 0;
    }

    private static abstract class VariableRequester<T, R extends Responses.ReadVariableResponse<T>> {
        private final ParticleDevice device;

        @WorkerThread
        abstract R callApi(String var1);

        VariableRequester(ParticleDevice device) {
            this.device = device;
        }

        @WorkerThread
        T getVariable(String variableName) throws ParticleCloudException, IOException, VariableDoesNotExistException {
            R reply;
            if (!this.device.deviceState.variables.containsKey(variableName)) {
                throw new VariableDoesNotExistException(variableName);
            }
            try {
                reply = this.callApi(variableName);
            }
            catch (RetrofitError e) {
                throw new ParticleCloudException((Exception)((Object)e));
            }
            if (!((Responses.ReadVariableResponse)reply).coreInfo.connected) {
                this.device.cloud.onDeviceNotConnected(this.device.deviceState);
                throw new IOException("Device is not connected.");
            }
            return ((Responses.ReadVariableResponse)reply).result;
        }
    }

    private static class TypedFakeFile
    extends TypedByteArray {
        private final String fileName;

        public TypedFakeFile(byte[] bytes) {
            this(bytes, "application/octet-stream", "tinker_firmware.bin");
        }

        public TypedFakeFile(byte[] bytes, String mimeType, String fileName) {
            super(mimeType, bytes);
            this.fileName = fileName;
        }

        public String fileName() {
            return this.fileName;
        }
    }

    private static interface FlashingChange {
        public void executeFlashingChange() throws RetrofitError;
    }

    public static enum KnownApp {
        TINKER("tinker");

        private final String appName;

        private KnownApp(String appName) {
            this.appName = appName;
        }

        public String getAppName() {
            return this.appName;
        }
    }

    public static class VariableDoesNotExistException
    extends Exception {
        public VariableDoesNotExistException(String variableName) {
            super("Variable " + variableName + " does not exist on this device");
        }
    }

    public static class FunctionDoesNotExistException
    extends Exception {
        public FunctionDoesNotExistException(String functionName) {
            super("Function " + functionName + " does not exist on this device");
        }
    }

    public static enum VariableType {
        INT,
        DOUBLE,
        STRING;

    }

    public static enum ParticleDeviceState {
        CAME_ONLINE,
        FLASH_STARTED,
        FLASH_SUCCEEDED,
        FLASH_FAILED,
        APP_HASH_UPDATED,
        ENTERED_SAFE_MODE,
        SAFE_MODE_UPDATER,
        WENT_OFFLINE,
        UNKNOWN;

    }

    public static enum ParticleDeviceType {
        CORE,
        PHOTON,
        P1,
        RASPBERRY_PI,
        RED_BEAR_DUO,
        BLUZ,
        DIGISTUMP_OAK,
        ELECTRON;


        public static ParticleDeviceType fromInt(int intValue) {
            switch (intValue) {
                case 0: {
                    return CORE;
                }
                case 8: {
                    return P1;
                }
                case 10: {
                    return ELECTRON;
                }
                case 31: {
                    return RASPBERRY_PI;
                }
                case 82: {
                    return DIGISTUMP_OAK;
                }
                case 88: {
                    return RED_BEAR_DUO;
                }
                case 103: {
                    return BLUZ;
                }
            }
            return PHOTON;
        }
    }
}

