/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.ServiceLoader;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.http.HttpRedirectPolicy;
import org.kaazing.net.ws.WebSocket;
import org.kaazing.net.ws.WebSocketExtension;

public abstract class WebSocketFactory {
    protected WebSocketFactory() {
    }

    public static WebSocketFactory createWebSocketFactory() {
        Class<WebSocketFactory> clazz = WebSocketFactory.class;
        ServiceLoader<WebSocketFactory> loader = ServiceLoader.load(clazz);
        return loader.iterator().next();
    }

    public abstract WebSocket createWebSocket(URI var1) throws URISyntaxException;

    public abstract WebSocket createWebSocket(URI var1, String ... var2) throws URISyntaxException;

    public abstract ChallengeHandler getDefaultChallengeHandler();

    public abstract int getDefaultConnectTimeout();

    public abstract Collection<String> getDefaultEnabledExtensions();

    public abstract HttpRedirectPolicy getDefaultRedirectPolicy();

    public abstract <T> T getDefaultParameter(WebSocketExtension.Parameter<T> var1);

    public abstract Collection<String> getSupportedExtensions();

    public abstract void setDefaultChallengeHandler(ChallengeHandler var1);

    public abstract void setDefaultConnectTimeout(int var1);

    public abstract void setDefaultEnabledExtensions(Collection<String> var1);

    public abstract void setDefaultRedirectPolicy(HttpRedirectPolicy var1);

    public abstract <T> void setDefaultParameter(WebSocketExtension.Parameter<T> var1, T var2);
}

