/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.ws;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public abstract class WebSocketExtension {
    private static final Map<String, WebSocketExtension> _extensions = new HashMap<String, WebSocketExtension>();
    private Collection<Parameter<?>> _parameters = new ArrayList();

    protected <T> Parameter<T> createParameter(String parameterName, Class<T> parameterType, EnumSet<Parameter.Metadata> parameterMetadata) {
        if (parameterName == null || parameterName.trim().length() == 0) {
            String s = "Parameter name cannot be null or empty";
            throw new IllegalArgumentException(s);
        }
        if (parameterType == null) {
            String s = String.format("Null type specified for parameter '%s'", parameterName);
            throw new IllegalArgumentException(s);
        }
        Parameter<T> parameter = new Parameter<T>(this, parameterName, parameterType, parameterMetadata);
        this._parameters.add(parameter);
        return parameter;
    }

    protected WebSocketExtension() {
        _extensions.put(this.name(), this);
    }

    public static WebSocketExtension getWebSocketExtension(String name) {
        return _extensions.get(name);
    }

    public Parameter<?> getParameter(String name) {
        Collection<Parameter<?>> extnParameters = this.getParameters();
        for (Parameter<?> extnParameter : extnParameters) {
            if (!extnParameter.name().equals(name)) continue;
            return extnParameter;
        }
        return null;
    }

    public Collection<Parameter<?>> getParameters() {
        if (this._parameters == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this._parameters);
    }

    public Collection<Parameter<?>> getParameters(Parameter.Metadata ... characteristics) {
        EnumSet<Parameter.Metadata> metadataSet;
        if (characteristics == null || characteristics.length == 0) {
            return Collections.emptySet();
        }
        int length = characteristics.length;
        if (length == 1) {
            metadataSet = EnumSet.of(characteristics[0]);
        } else {
            Parameter.Metadata[] array = new Parameter.Metadata[length - 1];
            System.arraycopy(characteristics, 1, array, 0, length - 1);
            metadataSet = EnumSet.of(characteristics[0], array);
        }
        Collection<Parameter<?>> extnParameters = this.getParameters();
        ArrayList result = new ArrayList();
        for (Parameter<?> extnParameter : extnParameters) {
            EnumSet<Parameter.Metadata> paramMetadata = extnParameter.metadata();
            if (!paramMetadata.containsAll(metadataSet)) continue;
            result.add(extnParameter);
        }
        return result;
    }

    public abstract String name();

    public static final class Parameter<T> {
        private final WebSocketExtension _parent;
        private final String _parameterName;
        private final Class<T> _parameterType;
        private final EnumSet<Metadata> _parameterMetadata;

        public Parameter(WebSocketExtension parent, String name, Class<T> type, EnumSet<Metadata> metadata) {
            if (name == null || name.trim().length() == 0) {
                String s = "Parameters must have a name";
                throw new IllegalArgumentException(s);
            }
            if (parent == null) {
                String s = String.format("Null parent specified for Parameter '%s'", name);
                throw new IllegalArgumentException(s);
            }
            this._parameterMetadata = metadata == null || metadata.isEmpty() ? EnumSet.noneOf(Metadata.class) : metadata;
            this._parent = parent;
            this._parameterName = name;
            this._parameterType = type;
        }

        public WebSocketExtension extension() {
            return this._parent;
        }

        public boolean anonymous() {
            return this._parameterMetadata.contains((Object)Metadata.ANONYMOUS);
        }

        public EnumSet<Metadata> metadata() {
            return this._parameterMetadata.clone();
        }

        public String name() {
            return this._parameterName;
        }

        public boolean required() {
            return this._parameterMetadata.contains((Object)Metadata.REQUIRED);
        }

        public boolean temporal() {
            return this._parameterMetadata.contains((Object)Metadata.TEMPORAL);
        }

        public Class<T> type() {
            return this._parameterType;
        }

        public static enum Metadata {
            ANONYMOUS,
            REQUIRED,
            TEMPORAL;

        }
    }
}

