/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl.url;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.kaazing.net.sse.impl.SseURLConnectionImpl;

public class SseURLStreamHandlerImpl
extends URLStreamHandler {
    private String _scheme;

    public SseURLStreamHandlerImpl(String scheme) {
        this._scheme = scheme;
    }

    @Override
    protected URLConnection openConnection(URL location) throws IOException {
        return new SseURLConnectionImpl(location);
    }

    @Override
    protected int getDefaultPort() {
        return 80;
    }

    @Override
    protected void parseURL(URL location, String spec, int start, int limit) {
        this._scheme = spec.substring(0, spec.indexOf("://"));
        URI specURI = this._getSpecURI(spec);
        String host = specURI.getHost();
        int port = specURI.getPort();
        String authority = specURI.getAuthority();
        String userInfo = specURI.getUserInfo();
        String path = specURI.getPath();
        String query = specURI.getQuery();
        this.setURL(location, this._scheme, host, port, authority, userInfo, path, query, null);
    }

    private URI _getSpecURI(String spec) {
        URI specURI = URI.create(spec);
        if (this._scheme.indexOf(58) == -1) {
            return specURI;
        }
        String schemeSpecificPart = specURI.getSchemeSpecificPart();
        return URI.create(schemeSpecificPart);
    }
}

