/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.sse.impl;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.net.impl.util.BlockingQueueImpl;
import org.kaazing.net.sse.SseEventReader;
import org.kaazing.net.sse.SseEventType;
import org.kaazing.net.sse.SseException;
import org.kaazing.net.sse.impl.SseEventSourceImpl;
import org.kaazing.net.sse.impl.SsePayload;

public class SseEventReaderImpl
extends SseEventReader {
    private static final String _CLASS_NAME = SseEventReaderImpl.class.getName();
    private static final Logger _LOG = Logger.getLogger(_CLASS_NAME);
    private final BlockingQueueImpl<Object> _sharedQueue;
    private final SseEventSourceImpl _eventSource;
    private SsePayload _payload;
    private SseEventType _eventType;
    private String _eventName;
    private String _data;

    public SseEventReaderImpl(SseEventSourceImpl eventSource, BlockingQueueImpl<Object> sharedQueue) {
        this._eventSource = eventSource;
        this._sharedQueue = sharedQueue;
        this._payload = null;
        this._eventType = null;
        this._eventName = null;
        this._data = null;
    }

    @Override
    public CharSequence getData() throws IOException {
        if (this._payload == null) {
            return null;
        }
        if (this._eventType != SseEventType.DATA) {
            String s = "readData() can only be used to read events of type SseEventType.DATA";
            throw new SseException(s);
        }
        return this._data;
    }

    @Override
    public String getName() {
        return this._eventName;
    }

    @Override
    public SseEventType getType() {
        return this._eventType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SseEventType next() throws IOException {
        if (this._sharedQueue.isDone()) {
            this._eventType = SseEventType.EOS;
            return this._eventType;
        }
        SseEventReaderImpl sseEventReaderImpl = this;
        synchronized (sseEventReaderImpl) {
            if (!this._eventSource.isConnected()) {
                this._eventType = SseEventType.EOS;
                return this._eventType;
            }
            try {
                this._payload = null;
                this._payload = (SsePayload)this._sharedQueue.take();
            }
            catch (InterruptedException ex) {
                _LOG.log(Level.FINE, ex.getMessage());
            }
            if (this._payload == null) {
                String s = "Reader has been interrupted maybe the connection is closed";
                _LOG.log(Level.FINE, _CLASS_NAME, s);
                this._eventType = SseEventType.EOS;
                return this._eventType;
            }
            this._data = this._payload.getData();
            this._eventName = this._payload.getEventName();
            this._eventType = this._payload.getData() == null ? SseEventType.EMPTY : SseEventType.DATA;
        }
        return this._eventType;
    }

    void close() throws IOException {
        this._sharedQueue.done();
        this._payload = null;
        this._eventType = null;
        this._data = null;
        this._eventName = null;
    }

    void reset() throws IOException {
        this._sharedQueue.reset();
        this._payload = null;
        this._eventType = null;
        this._data = null;
        this._eventName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CharSequence readData() throws IOException {
        if (!this._eventSource.isConnected()) {
            String s = "Can't read using the MessageReader if the event source is not connected";
            throw new SseException(s);
        }
        SseEventReaderImpl sseEventReaderImpl = this;
        synchronized (sseEventReaderImpl) {
            if (this._payload != null) {
                if (this._eventType != SseEventType.DATA) {
                    String s = "readData() can only be used to read events of type SseEventType.DATA";
                    throw new SseException(s);
                }
                this._payload = null;
                return this._data;
            }
            SseEventType type = this.next();
            if (type != SseEventType.DATA) {
                String s = "readData() can only be used to read events of type SseEventType.DATA";
                throw new SseException(s);
            }
            this._data = this._payload.getData();
            this._eventName = this._payload.getEventName();
            this._payload = null;
            return this._data;
        }
    }
}

