/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.impl.auth;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.auth.ChallengeRequest;
import org.kaazing.net.auth.ChallengeResponse;
import org.kaazing.net.auth.DispatchChallengeHandler;

public class DefaultDispatchChallengeHandler
extends DispatchChallengeHandler {
    static final String SCHEME_URI = "^(.*)://(.*)";
    static final Pattern SCHEME_URI_PATTERN = Pattern.compile("^(.*)://(.*)");
    private Node<ChallengeHandler, UriElement> rootNode = new Node();
    static Map<String, Integer> defaultPortsByScheme = new HashMap<String, Integer>();

    public void clear() {
        this.rootNode = new Node();
    }

    @Override
    public boolean canHandle(ChallengeRequest challengeRequest) {
        return this.lookup(challengeRequest) != null;
    }

    @Override
    public ChallengeResponse handle(ChallengeRequest challengeRequest) {
        ChallengeHandler challengeHandler = this.lookup(challengeRequest);
        if (challengeHandler == null) {
            return null;
        }
        return challengeHandler.handle(challengeRequest);
    }

    @Override
    public DispatchChallengeHandler register(String locationDescription, ChallengeHandler challengeHandler) {
        if (locationDescription == null || locationDescription.length() == 0) {
            throw new IllegalArgumentException("Must specify a location to handle challenges upon.");
        }
        if (challengeHandler == null) {
            throw new IllegalArgumentException("Must specify a handler to handle challenges.");
        }
        this.addChallengeHandlerAtLocation(locationDescription, challengeHandler);
        return this;
    }

    @Override
    public DispatchChallengeHandler unregister(String locationDescription, ChallengeHandler challengeHandler) {
        if (locationDescription == null || locationDescription.length() == 0) {
            throw new IllegalArgumentException("Must specify a location to un-register challenge handlers upon.");
        }
        if (challengeHandler == null) {
            throw new IllegalArgumentException("Must specify a handler to un-register.");
        }
        this.delChallengeHandlerAtLocation(locationDescription, challengeHandler);
        return this;
    }

    private void delChallengeHandlerAtLocation(String locationDescription, ChallengeHandler challengeHandler) {
        List<Token<UriElement>> tokens = this.tokenize(locationDescription);
        Node<ChallengeHandler, UriElement> cursor = this.rootNode;
        for (Token<UriElement> token : tokens) {
            if (!cursor.hasChild(token.getName(), token.getKind())) {
                return;
            }
            cursor = cursor.getChild(token.getName());
        }
        cursor.removeValue(challengeHandler);
    }

    private void addChallengeHandlerAtLocation(String locationDescription, ChallengeHandler challengeHandler) {
        List<Token<UriElement>> tokens = this.tokenize(locationDescription);
        Node<ChallengeHandler, UriElement> cursor = this.rootNode;
        for (Token<UriElement> token : tokens) {
            if (!cursor.hasChild(token.getName(), token.getKind())) {
                cursor = cursor.addChild(token.getName(), token.getKind());
                continue;
            }
            cursor = cursor.getChild(token.getName());
        }
        cursor.appendValues((ChallengeHandler[])new ChallengeHandler[]{challengeHandler});
    }

    public List<ChallengeHandler> lookup(String location) {
        Node<ChallengeHandler, UriElement> resultNode;
        List<ChallengeHandler> result = Collections.emptyList();
        if (location != null && (resultNode = this.findBestMatchingNode(location)) != null) {
            return resultNode.getValues();
        }
        return result;
    }

    ChallengeHandler lookup(ChallengeRequest challengeRequest) {
        List<ChallengeHandler> handlers;
        Node<ChallengeHandler, UriElement> resultNode;
        ChallengeHandler result = null;
        String location = challengeRequest.getLocation();
        if (location != null && (resultNode = this.findBestMatchingNode(location)) != null && (handlers = resultNode.getValues()) != null) {
            for (ChallengeHandler challengeHandler : handlers) {
                if (!challengeHandler.canHandle(challengeRequest)) continue;
                result = challengeHandler;
                break;
            }
        }
        return result;
    }

    private Node<ChallengeHandler, UriElement> findBestMatchingNode(String location) {
        List tokens = this.tokenize(location);
        int tokenIdx = 0;
        return this.rootNode.findBestMatchingNode(tokens, tokenIdx);
    }

    List<Token<UriElement>> tokenize(String s) throws IllegalArgumentException {
        int colonIdx;
        if (s == null || s.length() == 0) {
            return new ArrayList<Token<UriElement>>();
        }
        if (!SCHEME_URI_PATTERN.matcher(s).matches()) {
            s = "http://" + s;
        }
        URI uri = URI.create(s);
        ArrayList<Token<UriElement>> result = new ArrayList<Token<UriElement>>(10);
        String scheme = "http";
        if (uri.getScheme() != null) {
            scheme = uri.getScheme();
        }
        String host = uri.getHost();
        String parsedPortFromAuthority = null;
        String parsedUserInfoFromAuthority = null;
        String userFromAuthority = null;
        String passwordFromAuthority = null;
        if (host == null) {
            String authority = uri.getAuthority();
            if (authority != null) {
                host = authority;
                int asteriskIdx = host.indexOf("@");
                if (asteriskIdx >= 0) {
                    parsedUserInfoFromAuthority = host.substring(0, asteriskIdx);
                    host = host.substring(asteriskIdx + 1);
                    colonIdx = parsedUserInfoFromAuthority.indexOf(":");
                    if (colonIdx >= 0) {
                        userFromAuthority = parsedUserInfoFromAuthority.substring(0, colonIdx);
                        passwordFromAuthority = parsedUserInfoFromAuthority.substring(colonIdx + 1);
                    }
                }
                if ((colonIdx = host.indexOf(":")) >= 0) {
                    parsedPortFromAuthority = host.substring(colonIdx + 1);
                    host = host.substring(0, colonIdx);
                }
            } else {
                throw new IllegalArgumentException("Hostname is required.");
            }
        }
        List<String> hostParts = Arrays.asList(host.split("\\."));
        Collections.reverse(hostParts);
        for (String hostPart : hostParts) {
            result.add(new Token<UriElement>(hostPart, UriElement.HOST));
        }
        if (parsedPortFromAuthority != null) {
            result.add(new Token<UriElement>(parsedPortFromAuthority, UriElement.PORT));
        } else if (uri.getPort() > 0) {
            result.add(new Token<UriElement>(String.valueOf(uri.getPort()), UriElement.PORT));
        } else if (this.getDefaultPort(scheme) > 0) {
            result.add(new Token<UriElement>(String.valueOf(this.getDefaultPort(scheme)), UriElement.PORT));
        }
        if (parsedUserInfoFromAuthority != null) {
            if (userFromAuthority != null) {
                result.add(new Token<UriElement>(userFromAuthority, UriElement.USERINFO));
            }
            if (passwordFromAuthority != null) {
                result.add(new Token<UriElement>(passwordFromAuthority, UriElement.USERINFO));
            }
            if (userFromAuthority == null && passwordFromAuthority == null) {
                result.add(new Token<UriElement>(parsedUserInfoFromAuthority, UriElement.USERINFO));
            }
        } else if (uri.getUserInfo() != null) {
            String userInfo = uri.getUserInfo();
            colonIdx = userInfo.indexOf(":");
            if (colonIdx >= 0) {
                result.add(new Token<UriElement>(userInfo.substring(0, colonIdx), UriElement.USERINFO));
                result.add(new Token<UriElement>(userInfo.substring(colonIdx + 1), UriElement.USERINFO));
            } else {
                result.add(new Token<UriElement>(uri.getUserInfo(), UriElement.USERINFO));
            }
        }
        if (this.isNotBlank(uri.getPath())) {
            String path = uri.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (this.isNotBlank(path)) {
                for (String p : path.split("/")) {
                    result.add(new Token<UriElement>(p, UriElement.PATH));
                }
            }
        }
        return result;
    }

    int getDefaultPort(String scheme) {
        if (defaultPortsByScheme.containsKey(scheme.toLowerCase())) {
            return defaultPortsByScheme.get(scheme);
        }
        return -1;
    }

    private boolean isNotBlank(String s) {
        return s != null && s.length() > 0;
    }

    static {
        defaultPortsByScheme.put("http", 80);
        defaultPortsByScheme.put("ws", 80);
        defaultPortsByScheme.put("wss", 443);
        defaultPortsByScheme.put("https", 443);
    }

    static class Token<E extends Enum<E>> {
        E kind;
        String name;

        Token(String name, E element) {
            this.kind = element;
            this.name = name;
        }

        public E getKind() {
            return this.kind;
        }

        public void setKind(E kind) {
            this.kind = kind;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    static class Node<T, E extends Enum<E>> {
        private String name;
        private List<T> values = new ArrayList<T>(3);
        private Node<T, E> parent;
        private E kind;
        private Map<String, Node<T, E>> children = new LinkedHashMap<String, Node<T, E>>();

        public static String getWildcardChar() {
            return "*";
        }

        Node() {
            this.name = null;
            this.parent = null;
            this.kind = null;
        }

        private Node(String name, Node<T, E> parent, E kind) {
            this.name = name;
            this.parent = parent;
            this.kind = kind;
        }

        public Node<T, E> addChild(String name, E kind) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("A node may not have a null name.");
            }
            Node<T, E> result = new Node<T, E>(name, this, kind);
            this.children.put(name, result);
            return result;
        }

        public boolean hasChild(String name, E kind) {
            return null != this.getChild(name) && kind == this.getChild(name).getKind();
        }

        public Node<T, E> getChild(String name) {
            return this.children.get(name);
        }

        public int getDistanceFromRoot() {
            int result = 0;
            Node<T, E> cursor = this;
            while (!cursor.isRootNode()) {
                ++result;
                cursor = cursor.getParent();
            }
            return result;
        }

        @SafeVarargs
        public final void appendValues(T ... values) {
            if (this.isRootNode()) {
                throw new IllegalArgumentException("Cannot set a values on the root node.");
            }
            if (values != null) {
                this.values.addAll(Arrays.asList(values));
            }
        }

        public void removeValue(T value) {
            if (this.isRootNode()) {
                return;
            }
            this.values.remove(value);
        }

        public List<T> getValues() {
            return this.values;
        }

        public boolean hasValues() {
            return this.values != null && this.values.size() > 0;
        }

        public Node<T, E> getParent() {
            return this.parent;
        }

        public E getKind() {
            return this.kind;
        }

        public boolean isRootNode() {
            return this.parent == null;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasChildren() {
            return this.children != null && this.children.size() > 0;
        }

        public boolean isWildcard() {
            return this.name != null && this.name.equals(Node.getWildcardChar());
        }

        boolean hasWildcardChild() {
            return this.hasChildren() && this.children.keySet().contains(Node.getWildcardChar());
        }

        String getFullyQualifiedName() {
            StringBuilder b = new StringBuilder();
            ArrayList<String> name = new ArrayList<String>();
            Node<T, E> cursor = this;
            while (!cursor.isRootNode()) {
                name.add(cursor.name);
                cursor = cursor.parent;
            }
            Collections.reverse(name);
            for (String s : name) {
                b.append(s).append('.');
            }
            if (b.length() >= 1 && b.charAt(b.length() - 1) == '.') {
                b.deleteCharAt(b.length() - 1);
            }
            return b.toString();
        }

        public List<Node<T, E>> getChildrenAsList() {
            return new ArrayList<Node<T, E>>(this.children.values());
        }

        Node<T, E> findBestMatchingNode(List<Token<E>> tokens, int tokenIdx) {
            List<Node<T, E>> matches = this.findAllMatchingNodes(tokens, tokenIdx);
            Node<T, E> resultNode = null;
            int score = 0;
            for (Node<T, E> node : matches) {
                if (node.getDistanceFromRoot() <= score) continue;
                score = node.getDistanceFromRoot();
                resultNode = node;
            }
            return resultNode;
        }

        private List<Node<T, E>> findAllMatchingNodes(List<Token<E>> tokens, int tokenIdx) {
            ArrayList<Node<T, Node<T, E>>> result = new ArrayList<Node<T, Node<T, E>>>();
            List<Node<T, E>> nodes = this.getChildrenAsList();
            for (Node<T, E> node : nodes) {
                int matchResult = super.matches(tokens, tokenIdx);
                if (matchResult < 0) continue;
                if (matchResult >= tokens.size()) {
                    do {
                        if (node.hasValues()) {
                            result.add(node);
                        }
                        if (node.hasWildcardChild()) {
                            Node<T, E> child = node.getChild(Node.getWildcardChar());
                            if (child.getKind() != this.getKind()) {
                                node = null;
                                continue;
                            }
                            node = child;
                            continue;
                        }
                        node = null;
                    } while (node != null);
                    continue;
                }
                result.addAll(super.findAllMatchingNodes(tokens, matchResult));
            }
            return result;
        }

        private int matches(List<Token<E>> tokens, int tokenIdx) {
            if (tokenIdx < 0 || tokenIdx >= tokens.size()) {
                return -1;
            }
            if (this.matchesToken(tokens.get(tokenIdx))) {
                return tokenIdx + 1;
            }
            if (!this.isWildcard()) {
                return -1;
            }
            if (this.kind != tokens.get(tokenIdx).getKind()) {
                return -1;
            }
            while (++tokenIdx < tokens.size() && this.kind == tokens.get(tokenIdx).getKind()) {
            }
            return tokenIdx;
        }

        private boolean matchesToken(Token<E> token) {
            return this.getName().equals(token.getName()) && this.kind == token.getKind();
        }
    }

    static enum UriElement {
        HOST,
        USERINFO,
        PORT,
        PATH;

    }
}

