/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.net.impl.auth;

import java.net.PasswordAuthentication;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.kaazing.gateway.client.util.auth.LoginHandlerProvider;
import org.kaazing.net.auth.BasicChallengeHandler;
import org.kaazing.net.auth.ChallengeRequest;
import org.kaazing.net.auth.ChallengeResponse;
import org.kaazing.net.auth.LoginHandler;
import org.kaazing.net.impl.auth.BasicChallengeResponseFactory;
import org.kaazing.net.impl.auth.RealmUtils;

public class DefaultBasicChallengeHandler
extends BasicChallengeHandler
implements LoginHandlerProvider {
    private static final String CLASS_NAME = DefaultBasicChallengeHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private Map<String, LoginHandler> loginHandlersByRealm = new ConcurrentHashMap<String, LoginHandler>();
    private LoginHandler loginHandler;

    @Override
    public void setRealmLoginHandler(String realm, LoginHandler loginHandler) {
        if (realm == null) {
            throw new NullPointerException("realm");
        }
        if (loginHandler == null) {
            throw new NullPointerException("loginHandler");
        }
        this.loginHandlersByRealm.put(realm, loginHandler);
    }

    @Override
    public BasicChallengeHandler setLoginHandler(LoginHandler loginHandler) {
        this.loginHandler = loginHandler;
        return this;
    }

    @Override
    public LoginHandler getLoginHandler() {
        return this.loginHandler;
    }

    @Override
    public boolean canHandle(ChallengeRequest challengeRequest) {
        return challengeRequest != null && "Basic".equals(challengeRequest.getAuthenticationScheme());
    }

    @Override
    public ChallengeResponse handle(ChallengeRequest challengeRequest) {
        LOG.entering(CLASS_NAME, "handle", new String[]{challengeRequest.getLocation(), challengeRequest.getAuthenticationParameters()});
        if (challengeRequest.getLocation() != null) {
            PasswordAuthentication creds;
            LoginHandler loginHandler = this.getLoginHandler();
            String realm = RealmUtils.getRealm(challengeRequest);
            if (realm != null && this.loginHandlersByRealm.get(realm) != null) {
                loginHandler = this.loginHandlersByRealm.get(realm);
            }
            LOG.finest("BasicChallengeHandler.getResponse: login handler = " + loginHandler);
            if (loginHandler != null && (creds = loginHandler.getCredentials()) != null && creds.getUserName() != null && creds.getPassword() != null) {
                return BasicChallengeResponseFactory.create(creds, this);
            }
        }
        return null;
    }
}

