/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.util;

import java.net.URI;
import java.net.URISyntaxException;

public class URIUtils {
    public static URI replaceScheme(String location, String scheme) {
        try {
            return URIUtils.replaceScheme(new URI(location), scheme);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI/Scheme: replacing scheme with " + scheme + " for " + location);
        }
    }

    public static URI replaceScheme(URI uri, String scheme) {
        try {
            String location = uri.toString();
            int index = location.indexOf("://");
            return new URI(scheme + location.substring(index));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI/Scheme: replacing scheme with " + scheme + " for " + uri);
        }
    }

    public static URI replacePath(URI uri, String path) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI/Scheme: replacing path with '" + path + "' for " + uri);
        }
    }

    public static URI replaceQueryParameters(URI uri, String queryParams) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), queryParams, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI/Scheme: replacing query parameters with '" + queryParams + "' for " + uri);
        }
    }
}

