/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.transport.ws;

import java.nio.ByteBuffer;
import org.kaazing.gateway.client.transport.ws.WsMessage;

public class WsFrameEncodingSupport {
    public static ByteBuffer rfc6455Encode(WsMessage message, int maskValue) {
        boolean mask = true;
        boolean fin = true;
        ByteBuffer buf = message.getBytes();
        int remaining = buf.remaining();
        int offset = 6 + WsFrameEncodingSupport.calculateLengthSize(remaining);
        ByteBuffer b = ByteBuffer.allocate(offset + remaining);
        int start = b.position();
        byte b1 = (byte)(fin ? 128 : 0);
        byte b2 = -128;
        b1 = WsFrameEncodingSupport.doEncodeOpcode(b1, message);
        b2 = (byte)(b2 | WsFrameEncodingSupport.lenBits(remaining));
        b.put(b1).put(b2);
        WsFrameEncodingSupport.doEncodeLength(b, remaining);
        b.putInt(maskValue);
        b.put(buf);
        b.position(offset);
        WsFrameEncodingSupport.mask(b, maskValue);
        b.limit(b.position());
        b.position(start);
        return b;
    }

    private static int calculateLengthSize(int length) {
        if (length < 126) {
            return 0;
        }
        if (length < 65535) {
            return 2;
        }
        return 8;
    }

    private static byte doEncodeOpcode(byte b, WsMessage message) {
        switch (message.getKind()) {
            case TEXT: {
                b = (byte)(b | Opcode.TEXT.getCode());
                break;
            }
            case BINARY: {
                b = (byte)(b | Opcode.BINARY.getCode());
                break;
            }
            case PING: {
                b = (byte)(b | Opcode.PING.getCode());
                break;
            }
            case PONG: {
                b = (byte)(b | Opcode.PONG.getCode());
                break;
            }
            case CLOSE: {
                b = (byte)(b | Opcode.CLOSE.getCode());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized frame type: " + (Object)((Object)message.getKind()));
            }
        }
        return b;
    }

    private static byte lenBits(int length) {
        if (length < 126) {
            return (byte)length;
        }
        if (length < 65535) {
            return 126;
        }
        return 127;
    }

    private static void doEncodeLength(ByteBuffer buf, int length) {
        if (length < 126) {
            return;
        }
        if (length < 65535) {
            buf.putShort((short)length);
        } else {
            buf.putLong(length);
        }
    }

    public static void mask(ByteBuffer buf, int mask) {
        WsFrameEncodingSupport.unmask(buf, mask);
    }

    public static void unmask(ByteBuffer buf, int mask) {
        int remainder = buf.remaining() % 4;
        int remaining = buf.remaining() - remainder;
        int end = remaining + buf.position();
        while (buf.position() < end) {
            int plaintext = buf.getInt(buf.position()) ^ mask;
            buf.putInt(plaintext);
        }
        switch (remainder) {
            case 3: {
                byte b = (byte)(buf.get(buf.position()) ^ mask >> 24 & 0xFF);
                buf.put(b);
                b = (byte)(buf.get(buf.position()) ^ mask >> 16 & 0xFF);
                buf.put(b);
                b = (byte)(buf.get(buf.position()) ^ mask >> 8 & 0xFF);
                buf.put(b);
                break;
            }
            case 2: {
                byte b = (byte)(buf.get(buf.position()) ^ mask >> 24 & 0xFF);
                buf.put(b);
                b = (byte)(buf.get(buf.position()) ^ mask >> 16 & 0xFF);
                buf.put(b);
                break;
            }
            case 1: {
                byte b = (byte)(buf.get(buf.position()) ^ mask >> 24);
                buf.put(b);
                break;
            }
        }
    }

    protected static enum Opcode {
        CONTINUATION(0),
        TEXT(1),
        BINARY(2),
        RESERVED3(3),
        RESERVED4(4),
        RESERVED5(5),
        RESERVED6(6),
        RESERVED7(7),
        CLOSE(8),
        PING(9),
        PONG(10);

        private int code;

        public int getCode() {
            return this.code;
        }

        private Opcode(int code) {
            this.code = code;
        }

        static Opcode getById(int id) {
            Opcode result = null;
            for (Opcode temp : Opcode.values()) {
                if (id != temp.code) continue;
                result = temp;
                break;
            }
            return result;
        }
    }
}

