/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wsn;

import java.nio.charset.Charset;
import java.util.Random;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.EncoderOutput;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeEncoder;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class WebSocketNativeEncoderImpl
implements WebSocketNativeEncoder {
    private static final String CLASS_NAME = WebSocketNativeEncoderImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    protected WebSocketNativeEncoderImpl() {
    }

    @Override
    public void encodeTextMessage(WebSocketChannel channel, String message, EncoderOutput<WebSocketChannel> out) {
        LOG.entering(CLASS_NAME, "processTextMessage", message);
        WrappedByteBuffer buf = new WrappedByteBuffer();
        buf.putString(message, UTF8);
        buf.flip();
        WrappedByteBuffer buffer = this.encodeRFC6455(buf, false);
        out.write(channel, buffer);
    }

    @Override
    public void encodeBinaryMessage(WebSocketChannel channel, WrappedByteBuffer message, EncoderOutput<WebSocketChannel> out) {
        LOG.entering(CLASS_NAME, "processBinaryMessage", message);
        WrappedByteBuffer buffer = this.encodeRFC6455(message, true);
        out.write(channel, buffer);
    }

    private WrappedByteBuffer encodeRFC6455(WrappedByteBuffer buf, boolean isBinary) {
        boolean mask = true;
        int maskValue = new Random().nextInt();
        boolean fin = true;
        int remaining = buf.remaining();
        int offset = 6 + WebSocketNativeEncoderImpl.calculateLengthSize(remaining);
        WrappedByteBuffer b = WrappedByteBuffer.allocate(offset + remaining);
        int start = b.position();
        byte b1 = (byte)(fin ? 128 : 0);
        byte b2 = -128;
        b1 = WebSocketNativeEncoderImpl.doEncodeOpcode(b1, isBinary);
        b2 = (byte)(b2 | WebSocketNativeEncoderImpl.lenBits(remaining));
        b.put(b1).put(b2);
        WebSocketNativeEncoderImpl.doEncodeLength(b, remaining);
        b.putInt(maskValue);
        b.putBuffer(buf);
        b.position(offset);
        WebSocketNativeEncoderImpl.mask(b, maskValue);
        b.limit(b.position());
        b.position(start);
        return b;
    }

    private static byte doEncodeOpcode(byte b, boolean isBinary) {
        return (byte)(b | (isBinary ? 2 : 1));
    }

    private static byte lenBits(int length) {
        if (length < 126) {
            return (byte)length;
        }
        if (length < 65535) {
            return 126;
        }
        return 127;
    }

    private static int calculateLengthSize(int length) {
        if (length < 126) {
            return 0;
        }
        if (length < 65535) {
            return 2;
        }
        return 8;
    }

    private static void doEncodeLength(WrappedByteBuffer buf, int length) {
        if (length < 126) {
            return;
        }
        if (length < 65535) {
            buf.putShort((short)length);
        } else {
            buf.putLong(length);
        }
    }

    public static void mask(WrappedByteBuffer buf, int mask) {
        WebSocketNativeEncoderImpl.unmask(buf, mask);
    }

    public static void unmask(WrappedByteBuffer buf, int mask) {
        int remainder = buf.remaining() % 4;
        int remaining = buf.remaining() - remainder;
        int end = remaining + buf.position();
        while (buf.position() < end) {
            int plaintext = buf.getIntAt(buf.position()) ^ mask;
            buf.putInt(plaintext);
        }
        switch (remainder) {
            case 3: {
                byte b = (byte)(buf.getAt(buf.position()) ^ mask >> 24 & 0xFF);
                buf.put(b);
                b = (byte)(buf.getAt(buf.position()) ^ mask >> 16 & 0xFF);
                buf.put(b);
                b = (byte)(buf.getAt(buf.position()) ^ mask >> 8 & 0xFF);
                buf.put(b);
                break;
            }
            case 2: {
                byte b = (byte)(buf.getAt(buf.position()) ^ mask >> 24 & 0xFF);
                buf.put(b);
                b = (byte)(buf.getAt(buf.position()) ^ mask >> 16 & 0xFF);
                buf.put(b);
                break;
            }
            case 1: {
                byte b = (byte)(buf.getAt(buf.position()) ^ mask >> 24);
                buf.put(b);
                break;
            }
        }
    }
}

