/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wsn;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeChannel;
import org.kaazing.gateway.client.util.StringUtils;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.http.HttpRedirectPolicy;

public class WebSocketNativeBalancingHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeBalancingHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final Charset UTF8 = Charset.forName("UTF-8");

    @Override
    public void processConnect(WebSocketChannel channel, WSURI uri, String[] protocols) {
        LOG.entering(CLASS_NAME, "connect", new Object[]{uri, protocols});
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        wsChannel.balanced.set(0);
        this.nextHandler.processConnect(channel, (WSURI)uri.addQueryParameter(".kl=Y"), protocols);
    }

    private void reconnect(WebSocketChannel channel, WSURI uri, String protocol) {
        LOG.entering(CLASS_NAME, "reconnect", new Object[]{uri, protocol});
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        wsChannel.redirectUri = uri;
        WebSocketCompositeChannel compChannel = (WebSocketCompositeChannel)channel.getParent();
        HttpRedirectPolicy option = compChannel.getFollowRedirect();
        URI currentURI = channel.getLocation().getURI();
        URI redirectURI = uri.getURI();
        if (option != null && option.compare(currentURI, redirectURI) != 0) {
            String s = String.format("%s: Cannot redirect from '%s' to '%s'", option, currentURI, redirectURI);
            channel.preventFallback = true;
            throw new IllegalStateException(s);
        }
        wsChannel.reconnecting.compareAndSet(false, true);
    }

    void handleBinaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer message) {
        LOG.entering(CLASS_NAME, "handleMessageReceived", message);
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        if (wsChannel.balanced.get() <= 1 && message.remaining() >= 4) {
            String prefixString;
            byte[] prefix = new byte[3];
            message.mark();
            message.get(prefix);
            try {
                prefixString = new String(prefix, "UTF-8");
            }
            catch (UnsupportedEncodingException e1) {
                throw new IllegalStateException(e1);
            }
            if (prefixString.charAt(0) == '\uf0ff') {
                byte code = message.get();
                LOG.finest("Balancer code = " + code);
                if (code == 78) {
                    if (wsChannel.balanced.getAndIncrement() == 0) {
                        this.listener.connectionOpened(channel, "x-kaazing-handshake");
                    } else {
                        this.listener.connectionOpened(channel, "");
                    }
                } else if (code == 82) {
                    try {
                        String reconnectLocation = message.getString(UTF8);
                        LOG.finest("Balancer redirect location = " + StringUtils.stripControlCharacters(reconnectLocation));
                        WSURI uri = new WSURI(reconnectLocation);
                        this.reconnect(channel, uri, channel.getProtocol());
                        this.nextHandler.processClose(channel, 0, null);
                    }
                    catch (URISyntaxException e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                        this.listener.connectionFailed(channel, e);
                    }
                    catch (Exception e) {
                        LOG.log(Level.WARNING, e.getMessage(), e);
                        this.listener.connectionFailed(channel, e);
                    }
                }
            } else {
                message.reset();
                this.listener.binaryMessageReceived(wsChannel, message);
            }
        } else {
            this.listener.binaryMessageReceived(channel, message);
        }
    }

    void handleTextMessageReceived(WebSocketChannel channel, String message) {
        LOG.entering(CLASS_NAME, "handleTextMessageReceived", message);
        WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
        if (wsChannel.balanced.get() <= 1 && message.length() >= 2 && message.charAt(0) == '\uf0ff') {
            char code = message.charAt(1);
            LOG.finest("Balancer code = " + code);
            if (code == 'N') {
                if (wsChannel.balanced.incrementAndGet() == 1) {
                    this.listener.connectionOpened(channel, "x-kaazing-handshake");
                } else {
                    this.listener.connectionOpened(channel, "");
                }
            } else if (code == 'R') {
                try {
                    String reconnectLocation = message.substring(2);
                    LOG.finest("Balancer redirect location = " + StringUtils.stripControlCharacters(reconnectLocation));
                    WSURI uri = new WSURI(reconnectLocation);
                    this.reconnect(channel, uri, channel.getProtocol());
                    this.nextHandler.processClose(channel, 0, null);
                }
                catch (URISyntaxException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    this.listener.connectionFailed(channel, e);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    this.listener.connectionFailed(channel, e);
                }
            } else {
                this.listener.textMessageReceived(channel, message);
            }
        } else {
            this.listener.textMessageReceived(channel, message);
        }
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                if (!"x-kaazing-handshake".equals(protocol)) {
                    WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
                    wsChannel.balanced.set(2);
                    WebSocketNativeBalancingHandler.this.listener.connectionOpened(channel, protocol);
                }
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                try {
                    LOG.finest("Balancer redirect location = " + StringUtils.stripControlCharacters(location));
                    WSURI uri = new WSURI(location);
                    WebSocketNativeBalancingHandler.this.reconnect(channel, uri, channel.getProtocol());
                    WebSocketNativeBalancingHandler.this.nextHandler.processClose(channel, 0, null);
                }
                catch (URISyntaxException e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    WebSocketNativeBalancingHandler.this.listener.connectionFailed(channel, e);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, e.getMessage(), e);
                    WebSocketNativeBalancingHandler.this.listener.connectionFailed(channel, e);
                }
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeBalancingHandler.this.listener.authenticationRequested(channel, location, challenge);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
                WebSocketNativeBalancingHandler.this.handleBinaryMessageReceived(channel, buf);
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketNativeBalancingHandler.this.handleTextMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketNativeChannel wsChannel = (WebSocketNativeChannel)channel;
                if (wsChannel.reconnecting.compareAndSet(true, false)) {
                    String[] nextProtocols;
                    wsChannel.reconnected.set(true);
                    String[] requestedProtocols = wsChannel.getRequestedProtocols();
                    if (requestedProtocols == null || requestedProtocols.length == 0) {
                        nextProtocols = new String[]{"x-kaazing-handshake"};
                    } else {
                        nextProtocols = new String[requestedProtocols.length + 1];
                        nextProtocols[0] = "x-kaazing-handshake";
                        System.arraycopy(requestedProtocols, 0, nextProtocols, 1, requestedProtocols.length);
                    }
                    WebSocketNativeBalancingHandler.this.processConnect(channel, wsChannel.redirectUri, nextProtocols);
                } else {
                    WebSocketNativeBalancingHandler.this.listener.connectionClosed(channel, wasClean, code, reason);
                }
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeBalancingHandler.this.listener.connectionClosed(channel, ex);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                if (ex == null) {
                    WebSocketNativeBalancingHandler.this.listener.connectionClosed(channel, false, 0, null);
                } else {
                    WebSocketNativeBalancingHandler.this.listener.connectionClosed(channel, ex);
                }
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
                WebSocketNativeBalancingHandler.this.listener.commandMessageReceived(channel, message);
            }
        });
    }
}

