/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wsn;

import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.CommandMessage;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.WebSocketHandler;
import org.kaazing.gateway.client.impl.WebSocketHandlerAdapter;
import org.kaazing.gateway.client.impl.WebSocketHandlerListener;
import org.kaazing.gateway.client.impl.auth.AuthenticationUtil;
import org.kaazing.gateway.client.impl.util.WSURI;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.gateway.client.impl.wsn.WebSocketNativeChannel;
import org.kaazing.gateway.client.util.WrappedByteBuffer;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.auth.ChallengeRequest;
import org.kaazing.net.auth.ChallengeResponse;
import org.kaazing.net.impl.util.ResumableTimer;

public class WebSocketNativeAuthenticationHandler
extends WebSocketHandlerAdapter {
    private static final String CLASS_NAME = WebSocketNativeAuthenticationHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    private void handleAuthenticationRequested(WebSocketChannel channel, String location, String challenge) {
        WebSocketCompositeChannel parent;
        LOG.entering(CLASS_NAME, "handleAuthenticationRequested");
        channel.authenticationReceived = true;
        WebSocketNativeChannel ch = (WebSocketNativeChannel)channel;
        ResumableTimer connectTimer = null;
        if ((WebSocketCompositeChannel)channel.getParent() != null && (connectTimer = (parent = (WebSocketCompositeChannel)channel.getParent()).getConnectTimer()) != null) {
            connectTimer.pause();
        }
        WSURI serverURI = ch.redirectUri != null ? ch.redirectUri : channel.getLocation();
        ChallengeRequest challengeRequest = new ChallengeRequest(serverURI.toString(), challenge);
        try {
            channel.challengeResponse = AuthenticationUtil.getChallengeResponse(channel, challengeRequest, channel.challengeResponse);
        }
        catch (Exception e) {
            this.clearAuthenticationCredentials(channel);
            this.doError(channel, e);
            return;
        }
        char[] authResponse = channel.challengeResponse.getCredentials();
        if (authResponse == null) {
            this.doError(channel, new IllegalStateException("No response possible for challenge"));
            return;
        }
        if (connectTimer != null) {
            connectTimer.resume();
        }
        this.processAuthorize(channel, String.valueOf(authResponse));
        this.clearAuthenticationCredentials(channel);
    }

    private void doError(WebSocketChannel channel, Exception exception) {
        LOG.entering(CLASS_NAME, "handleConnectionClosed");
        this.nextHandler.processClose(channel, 1000, null);
        this.listener.connectionClosed(channel, exception);
    }

    private void clearAuthenticationCredentials(WebSocketChannel channel) {
        ChallengeHandler nextChallengeHandler = null;
        if (channel.challengeResponse != null) {
            nextChallengeHandler = channel.challengeResponse.getNextChallengeHandler();
            channel.challengeResponse.clearCredentials();
            channel.challengeResponse = null;
        }
        channel.challengeResponse = new ChallengeResponse(null, nextChallengeHandler);
    }

    @Override
    public void setNextHandler(WebSocketHandler handler) {
        super.setNextHandler(handler);
        handler.setListener(new WebSocketHandlerListener(){

            @Override
            public void connectionOpened(WebSocketChannel channel, String protocol) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.connectionOpened(channel, protocol);
            }

            @Override
            public void redirected(WebSocketChannel channel, String location) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.redirected(channel, location);
            }

            @Override
            public void authenticationRequested(WebSocketChannel channel, String location, String challenge) {
                WebSocketNativeAuthenticationHandler.this.handleAuthenticationRequested(channel, location, challenge);
            }

            @Override
            public void binaryMessageReceived(WebSocketChannel channel, WrappedByteBuffer buf) {
                WebSocketNativeAuthenticationHandler.this.listener.binaryMessageReceived(channel, buf);
            }

            @Override
            public void textMessageReceived(WebSocketChannel channel, String message) {
                WebSocketNativeAuthenticationHandler.this.listener.textMessageReceived(channel, message);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, boolean wasClean, int code, String reason) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.connectionClosed(channel, wasClean, code, reason);
            }

            @Override
            public void connectionClosed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeAuthenticationHandler.this.listener.connectionClosed(channel, ex);
            }

            @Override
            public void connectionFailed(WebSocketChannel channel, Exception ex) {
                WebSocketNativeAuthenticationHandler.this.clearAuthenticationCredentials(channel);
                WebSocketNativeAuthenticationHandler.this.listener.connectionFailed(channel, ex);
            }

            @Override
            public void commandMessageReceived(WebSocketChannel channel, CommandMessage message) {
            }
        });
    }
}

