/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wseb;

import java.nio.charset.Charset;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.EncoderOutput;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestTransportHandler;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.wseb.UpstreamChannel;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandler;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandlerFactory;
import org.kaazing.gateway.client.impl.wseb.UpstreamHandlerListener;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedEncoder;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedEncoderImpl;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

class UpstreamHandlerImpl
implements UpstreamHandler {
    static final String CLASS_NAME = UpstreamHandlerImpl.class.getName();
    static final Logger LOG = Logger.getLogger(CLASS_NAME);
    static UpstreamHandlerFactory FACTORY = UpstreamHandlerImpl::new;
    private static final byte WSF_COMMAND_FRAME_START = 1;
    private static final byte WSF_COMMAND_FRAME_END = -1;
    private static final byte WSE_PONG_FRAME_CODE = -118;
    private static final byte[] RECONNECT_EVENT_BYTES = new byte[]{1, 48, 49, -1};
    private static final byte[] CLOSE_EVENT_BYTES = new byte[]{1, 48, 50, -1};
    WebSocketEmulatedEncoder<UpstreamChannel> encoder = new WebSocketEmulatedEncoderImpl<UpstreamChannel>();
    private EncoderOutput<UpstreamChannel> out = this::processMessageWrite;
    HttpRequestHandler nextHandler;
    UpstreamHandlerListener listener;

    UpstreamHandlerImpl() {
        HttpRequestHandler transportHandler = HttpRequestTransportHandler.DEFAULT_FACTORY.createHandler();
        this.setNextHandler(transportHandler);
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        this.nextHandler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                UpstreamChannel channel = (UpstreamChannel)request.parent;
                ConcurrentLinkedQueue<WrappedByteBuffer> sendQueue = channel.sendQueue;
                WrappedByteBuffer payload = WrappedByteBuffer.allocate(1024);
                while (!sendQueue.isEmpty()) {
                    payload.putBuffer(sendQueue.poll());
                }
                payload.putBytes(RECONNECT_EVENT_BYTES);
                payload.flip();
                UpstreamHandlerImpl.this.nextHandler.processSend(request, payload);
            }

            @Override
            public void requestOpened(HttpRequest request) {
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                UpstreamChannel channel = (UpstreamChannel)request.parent;
                channel.sendInFlight.set(false);
                if (!channel.sendQueue.isEmpty()) {
                    UpstreamHandlerImpl.this.flushIfNecessary(channel);
                }
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                UpstreamChannel channel = (UpstreamChannel)request.parent;
                channel.sendInFlight.set(false);
                UpstreamHandlerImpl.this.listener.upstreamFailed(channel, exception);
            }

            @Override
            public void requestAborted(HttpRequest request) {
            }

            @Override
            public void requestClosed(HttpRequest request) {
            }
        });
    }

    @Override
    public void processOpen(UpstreamChannel channel) {
    }

    @Override
    public void processTextMessage(UpstreamChannel channel, String message) {
        LOG.entering(CLASS_NAME, "processsTextMessage", message);
        this.encoder.encodeTextMessage(channel, message, this.out);
    }

    @Override
    public void processBinaryMessage(UpstreamChannel channel, WrappedByteBuffer message) {
        LOG.entering(CLASS_NAME, "processsBinaryMessage", message);
        this.encoder.encodeBinaryMessage(channel, message, this.out);
    }

    private void processMessageWrite(UpstreamChannel channel, WrappedByteBuffer payload) {
        LOG.entering(CLASS_NAME, "processMessageWrite", payload);
        channel.sendQueue.offer(payload);
        this.flushIfNecessary(channel);
    }

    private void flushIfNecessary(UpstreamChannel channel) {
        LOG.entering(CLASS_NAME, "flushIfNecessary");
        if (channel.sendInFlight.compareAndSet(false, true)) {
            HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.POST, channel.location, false);
            request.setHeader("Content-Type", "application/octet-stream");
            if (channel.cookie != null) {
                request.setHeader("Cookie", channel.cookie);
            }
            request.setHeader("X-Sequence-No", Long.toString(channel.nextSequence()));
            request.parent = channel;
            channel.request = request;
            this.nextHandler.processOpen(request);
        }
    }

    @Override
    public void processClose(UpstreamChannel channel, int code, String reason) {
        code = 0;
        if (code == 0 || code == 1005) {
            this.processMessageWrite(channel, WrappedByteBuffer.wrap(CLOSE_EVENT_BYTES));
        } else {
            WrappedByteBuffer buf = new WrappedByteBuffer();
            buf.put(CLOSE_EVENT_BYTES, 0, 3);
            buf.putShort((short)code);
            buf.putString(reason, Charset.forName("UTF-8"));
            buf.put((byte)-1);
            buf.flip();
            this.processMessageWrite(channel, buf);
        }
    }

    @Override
    public void setListener(UpstreamHandlerListener listener) {
        this.listener = listener;
    }

    @Override
    public void processPong(UpstreamChannel upstreamChannel) {
        WrappedByteBuffer pongBuffer = WrappedByteBuffer.allocate(2);
        pongBuffer.put((byte)-118);
        pongBuffer.put((byte)0);
        pongBuffer.flip();
        this.processMessageWrite(upstreamChannel, pongBuffer);
    }
}

