/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.wseb;

import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.DecoderInput;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpRequestTransportHandler;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.impl.ws.CloseCommandMessage;
import org.kaazing.gateway.client.impl.ws.WebSocketReAuthenticateHandler;
import org.kaazing.gateway.client.impl.wseb.DownstreamChannel;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandler;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandlerFactory;
import org.kaazing.gateway.client.impl.wseb.DownstreamHandlerListener;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedChannel;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedDecoder;
import org.kaazing.gateway.client.impl.wseb.WebSocketEmulatedDecoderListener;
import org.kaazing.gateway.client.util.HttpURI;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

class DownstreamHandlerImpl
implements DownstreamHandler {
    private static final String CLASS_NAME = DownstreamHandlerImpl.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static String IDLE_TIMEOUT_HEADER = "X-Idle-Timeout";
    static DownstreamHandlerFactory FACTORY = DownstreamHandlerImpl::new;
    private static final int PROXY_MODE_TIMEOUT_MILLIS = 5000;
    static boolean DISABLE_FALLBACK = false;
    private HttpRequestHandler nextHandler;
    private DownstreamHandlerListener listener;
    DecoderInput<DownstreamChannel> in = channel -> channel.buffersToRead.poll();

    DownstreamHandlerImpl() {
        LOG.entering(CLASS_NAME, "<init>");
        HttpRequestHandler transportHandler = HttpRequestTransportHandler.DEFAULT_FACTORY.createHandler();
        this.setNextHandler(transportHandler);
    }

    @Override
    public void processConnect(DownstreamChannel channel, HttpURI uri) {
        LOG.entering(CLASS_NAME, "processConnect");
        this.makeRequest(channel, uri);
    }

    private void makeRequest(final DownstreamChannel channel, HttpURI uri) {
        LOG.entering(CLASS_NAME, "makeRequest");
        try {
            this.stopIdleTimer(channel);
            HttpURI requestUri = HttpURI.replaceScheme(uri.getURI(), uri.getScheme().replaceAll("ws", "http"));
            HttpRequest request = HttpRequest.HTTP_REQUEST_FACTORY.createHttpRequest(HttpRequest.Method.POST, requestUri, true);
            request.parent = channel;
            channel.outstandingRequests.add(request);
            if (channel.cookie != null) {
                request.setHeader("Cookie", channel.cookie);
            }
            request.setHeader("X-Sequence-No", Long.toString(channel.nextSequence()));
            this.nextHandler.processOpen(request);
            if (!DISABLE_FALLBACK && channel.attemptProxyModeFallback.get()) {
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        DownstreamHandlerImpl.this.fallbackToProxyMode(channel);
                    }
                };
                Timer t = new Timer("ProxyModeFallback", true);
                t.schedule(timerTask, 5000L);
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            this.listener.downstreamFailed(channel, e);
        }
    }

    private void fallbackToProxyMode(DownstreamChannel channel) {
        if (channel.attemptProxyModeFallback.get()) {
            LOG.fine("useProxyMode");
            channel.attemptProxyModeFallback.set(false);
            HttpURI uri = channel.location;
            if (uri.getQuery() == null || !uri.getQuery().contains(".ki=p")) {
                channel.location = uri = (HttpURI)channel.location.addQueryParameter(".ki=p");
            }
            this.makeRequest(channel, uri);
        }
    }

    private void reconnectIfNecessary(DownstreamChannel channel) {
        LOG.entering(CLASS_NAME, "reconnectIfNecessary");
        if (channel.closing.get()) {
            if (channel.outstandingRequests.size() == 0) {
                LOG.fine("Closing: " + channel);
                this.listener.downstreamClosed(channel);
            }
        } else if (channel.reconnecting.compareAndSet(true, false)) {
            LOG.fine("Reconnecting: " + channel);
            this.makeRequest(channel, channel.location);
        } else {
            LOG.fine("Downstream failed: " + channel);
            this.listener.downstreamFailed(channel, new Exception("Connection closed abruptly"));
        }
    }

    private void startIdleTimer(final DownstreamChannel downstreamChannel, int delayInMilliseconds) {
        LOG.fine("Starting idle timer");
        if (downstreamChannel.idleTimer != null) {
            downstreamChannel.idleTimer.cancel();
            downstreamChannel.idleTimer = null;
        }
        downstreamChannel.idleTimer = new Timer();
        downstreamChannel.idleTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DownstreamHandlerImpl.this.idleTimerHandler(downstreamChannel);
            }
        }, delayInMilliseconds);
    }

    private void idleTimerHandler(DownstreamChannel downstreamChannel) {
        LOG.fine("Idle timer scheduled");
        int idleDuration = (int)(System.currentTimeMillis() - downstreamChannel.lastMessageTimestamp.get());
        if (idleDuration > downstreamChannel.idleTimeout.get()) {
            String message = "idle duration - " + idleDuration + " exceeded idle timeout - " + downstreamChannel.idleTimeout;
            LOG.fine(message);
            Exception exception = new Exception(message);
            this.listener.downstreamFailed(downstreamChannel, exception);
        } else {
            this.startIdleTimer(downstreamChannel, downstreamChannel.idleTimeout.get() - idleDuration);
        }
    }

    private void stopIdleTimer(DownstreamChannel downstreamChannel) {
        LOG.fine("Stopping idle timer");
        if (downstreamChannel.idleTimer != null) {
            downstreamChannel.idleTimer.cancel();
            downstreamChannel.idleTimer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processProgressEvent(DownstreamChannel channel, WrappedByteBuffer buffer) {
        LOG.entering(CLASS_NAME, "processProgressEvent", buffer);
        try {
            channel.lastMessageTimestamp.set(System.currentTimeMillis());
            channel.buffersToRead.add(buffer);
            WebSocketEmulatedDecoderListener<DownstreamChannel> decoderListener = new WebSocketEmulatedDecoderListener<DownstreamChannel>(){

                @Override
                public void messageDecoded(DownstreamChannel channel, WrappedByteBuffer message) {
                    DownstreamHandlerImpl.this.processMessage(channel, message);
                }

                @Override
                public void messageDecoded(DownstreamChannel channel, String message) {
                    DownstreamHandlerImpl.this.processMessage(channel, message);
                }

                @Override
                public void commandDecoded(DownstreamChannel channel, WrappedByteBuffer command) {
                    byte commandByte = command.array()[0];
                    if (commandByte == 48 && command.array()[1] == 49) {
                        LOG.fine("Reconnect command");
                        channel.reconnecting.set(true);
                    } else if (commandByte == 48 && command.array()[1] == 50) {
                        channel.closing.set(true);
                        DownstreamHandlerImpl.this.stopIdleTimer(channel);
                        int code = 1005;
                        String reason = null;
                        command.skip(2);
                        if (command.hasRemaining()) {
                            code = command.getShort();
                        }
                        if (command.hasRemaining()) {
                            reason = command.getString(Charset.forName("UTF-8"));
                        }
                        CloseCommandMessage message = new CloseCommandMessage(code, reason);
                        DownstreamHandlerImpl.this.listener.commandMessageReceived(channel, message);
                    }
                }

                @Override
                public void pingReceived(DownstreamChannel channel) {
                    DownstreamHandlerImpl.this.listener.pingReceived(channel);
                }
            };
            WebSocketEmulatedDecoder<DownstreamChannel> webSocketEmulatedDecoder = channel.decoder;
            synchronized (webSocketEmulatedDecoder) {
                channel.decoder.decode(channel, this.in, decoderListener);
            }
        }
        catch (Exception e) {
            LOG.log(Level.FINE, e.getMessage(), e);
            e.printStackTrace();
            this.listener.downstreamFailed(channel, e);
        }
    }

    private void processMessage(DownstreamChannel channel, String message) {
        this.listener.textMessageReceived(channel, message);
    }

    private void processMessage(DownstreamChannel channel, WrappedByteBuffer message) {
        this.listener.binaryMessageReceived(channel, message);
    }

    void handleReAuthenticationRequested(DownstreamChannel channel, String location, String challenge) {
        LOG.entering(CLASS_NAME, "handleAuthenticationRequested");
        String url = channel.location.getScheme() + "://" + channel.location.getURI().getAuthority() + location;
        WebSocketReAuthenticateHandler reAuthHandler = new WebSocketReAuthenticateHandler();
        try {
            WebSocketEmulatedChannel parent = (WebSocketEmulatedChannel)channel.getParent();
            if (parent.redirectUri != null) {
                url = parent.redirectUri.getScheme() + "://" + parent.redirectUri.getURI().getAuthority() + location;
            }
            WebSocketEmulatedChannel revalidateChannel = new WebSocketEmulatedChannel(parent.getLocation());
            revalidateChannel.redirectUri = parent.redirectUri;
            revalidateChannel.setParent(parent.getParent());
            reAuthHandler.processOpen(revalidateChannel, new HttpURI(url));
        }
        catch (URISyntaxException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void processClose(DownstreamChannel channel) {
        LOG.entering(CLASS_NAME, "stop");
        for (HttpRequest request : channel.outstandingRequests) {
            this.nextHandler.processAbort(request);
        }
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                DownstreamHandlerImpl.this.nextHandler.processSend(request, WrappedByteBuffer.wrap(">|<".getBytes()));
            }

            @Override
            public void requestOpened(HttpRequest request) {
                HttpResponse response = request.getResponse();
                if (response != null) {
                    int idleTimeout;
                    DownstreamChannel channel = (DownstreamChannel)request.parent;
                    channel.attemptProxyModeFallback.set(false);
                    String idleTimeoutString = response.getHeader(IDLE_TIMEOUT_HEADER);
                    if (idleTimeoutString != null && (idleTimeout = Integer.parseInt(idleTimeoutString)) > 0) {
                        channel.idleTimeout.set(idleTimeout *= 1000);
                        channel.lastMessageTimestamp.set(System.currentTimeMillis());
                        DownstreamHandlerImpl.this.startIdleTimer(channel, idleTimeout);
                    }
                    DownstreamHandlerImpl.this.listener.downstreamOpened(channel);
                }
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                DownstreamHandlerImpl.this.processProgressEvent(channel, payload);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                LOG.entering(CLASS_NAME, "requestLoaded", request);
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                channel.outstandingRequests.remove(request);
                DownstreamHandlerImpl.this.reconnectIfNecessary(channel);
            }

            @Override
            public void requestClosed(HttpRequest request) {
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                LOG.entering(CLASS_NAME, "errorOccurred", request);
                DownstreamChannel channel = (DownstreamChannel)request.parent;
                DownstreamHandlerImpl.this.listener.downstreamFailed(channel, exception);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                LOG.entering(CLASS_NAME, "errorOccurred", request);
            }
        });
    }

    @Override
    public void setListener(DownstreamHandlerListener listener) {
        this.listener = listener;
    }
}

