/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.http;

import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.http.HttpRequest;
import org.kaazing.gateway.client.impl.http.HttpRequestHandler;
import org.kaazing.gateway.client.impl.http.HttpRequestHandlerAdapter;
import org.kaazing.gateway.client.impl.http.HttpRequestListener;
import org.kaazing.gateway.client.impl.http.HttpResponse;
import org.kaazing.gateway.client.util.WrappedByteBuffer;

public class HttpRequestLoggingHandler
extends HttpRequestHandlerAdapter {
    private static final String CLASS_NAME = HttpRequestLoggingHandler.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    @Override
    public void processOpen(HttpRequest request) {
        LOG.fine("->OPEN: " + request);
        super.processOpen(request);
    }

    @Override
    public void processSend(HttpRequest request, WrappedByteBuffer buffer) {
        LOG.fine("->SEND: " + request + " " + buffer.getHexDump());
        super.processSend(request, buffer);
    }

    @Override
    public void processAbort(HttpRequest request) {
        LOG.fine("->ABORT: " + request);
        super.processAbort(request);
    }

    @Override
    public void setNextHandler(HttpRequestHandler handler) {
        this.nextHandler = handler;
        handler.setListener(new HttpRequestListener(){

            @Override
            public void requestReady(HttpRequest request) {
                LOG.fine("<-READY: " + request);
                HttpRequestLoggingHandler.this.listener.requestReady(request);
            }

            @Override
            public void requestProgressed(HttpRequest request, WrappedByteBuffer payload) {
                LOG.fine("<-PROGRESSED: " + request + " " + payload.getHexDump());
                HttpRequestLoggingHandler.this.listener.requestProgressed(request, payload);
            }

            @Override
            public void requestOpened(HttpRequest request) {
                LOG.fine("<-OPENED: " + request);
                HttpRequestLoggingHandler.this.listener.requestOpened(request);
            }

            @Override
            public void requestLoaded(HttpRequest request, HttpResponse response) {
                LOG.fine("<-LOADED: " + request + " " + response);
                HttpRequestLoggingHandler.this.listener.requestLoaded(request, response);
            }

            @Override
            public void requestClosed(HttpRequest request) {
                LOG.fine("<-CLOSED: " + request);
                HttpRequestLoggingHandler.this.listener.requestClosed(request);
            }

            @Override
            public void requestAborted(HttpRequest request) {
                LOG.fine("<-ABORTED: " + request);
                HttpRequestLoggingHandler.this.listener.requestAborted(request);
            }

            @Override
            public void errorOccurred(HttpRequest request, Exception exception) {
                LOG.fine("<-ERROR: " + request);
                HttpRequestLoggingHandler.this.listener.errorOccurred(request, exception);
            }
        });
    }
}

