/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.bridge;

import java.net.URL;
import java.net.URLClassLoader;

public abstract class ClassLoaderFactory {
    private static ClassLoaderFactory sharedInstance = new DefaultClassLoaderFactory();

    public abstract ClassLoader createClassLoader(URL var1, ClassLoader var2) throws Exception;

    public abstract String getQueryParameters();

    public abstract String getCrossOriginProxyClass();

    public static void setInstance(ClassLoaderFactory factory) {
        sharedInstance = factory;
    }

    public static ClassLoaderFactory getInstance() {
        return sharedInstance;
    }

    private static class DefaultClassLoaderFactory
    extends ClassLoaderFactory {
        private DefaultClassLoaderFactory() {
        }

        @Override
        public ClassLoader createClassLoader(URL url, ClassLoader parent) throws Exception {
            URL[] urls = new URL[]{url};
            return URLClassLoader.newInstance(urls, parent);
        }

        @Override
        public String getQueryParameters() {
            return "?.kr=xsj";
        }

        @Override
        public String getCrossOriginProxyClass() {
            return "org.kaazing.gateway.bridge.CrossOriginProxy";
        }
    }
}

