/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.bridge;

import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.net.URL;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.bridge.ClassLoaderFactory;
import org.kaazing.gateway.client.impl.bridge.Proxy;
import org.kaazing.gateway.client.impl.bridge.ProxyListener;
import org.kaazing.gateway.client.impl.bridge.XoaEvent;
import org.kaazing.gateway.client.util.StringUtils;

public class BridgeUtil {
    private static final String CLASS_NAME = BridgeUtil.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);
    private static final String SOA_MESSAGE = "soaMessage";
    private static final String XOP_MESSAGE = "xopMessage";
    private static Map<String, PropertyChangeSupport> schemeAuthorityToXopMap = new ConcurrentHashMap<String, PropertyChangeSupport>();
    private static Map<Integer, Proxy> handlerIdToHtml5ObjectMap = new ConcurrentHashMap<Integer, Proxy>();
    private static AtomicInteger sHtml5ObjectIdCounter = new AtomicInteger(new SecureRandom().nextInt(10000));
    static Object token = null;

    public static Object getIdentifier() {
        LOG.exiting(CLASS_NAME, "getIdentifier", token);
        return token;
    }

    static void processEvent(XoaEvent event) {
        LOG.entering(CLASS_NAME, "dispatchEventToXoa", event);
        LOG.log(Level.FINEST, "SOA --> XOA: {1}", event);
        Integer handlerId = event.getHandlerId();
        if (handlerId == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Null handlerId");
            }
            return;
        }
        String eventType = event.getKind().toString();
        Object[] params = event.getParams();
        Object[] args = new Object[]{handlerId, eventType, params};
        PropertyChangeSupport xop = BridgeUtil.getCrossOriginProxy(handlerId);
        if (xop == null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Null xop for handler " + handlerId);
            }
            return;
        }
        xop.firePropertyChange(SOA_MESSAGE, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void eventReceived(Integer handlerId, String eventType, Object[] params) {
        LOG.entering(CLASS_NAME, "eventReceived", new Object[]{handlerId, eventType, params});
        Proxy obj = handlerIdToHtml5ObjectMap.get(handlerId);
        if (obj == null) {
            LOG.fine("Object by id: " + handlerId + " could not be located in the system");
            return;
        }
        try {
            XoaEvent.XoaEventKind name = XoaEvent.XoaEventKind.getName(eventType);
            obj.eventReceived(handlerId, name, params);
        }
        finally {
            if (eventType.equals((Object)XoaEvent.XoaEventKind.CLOSED) || eventType.equals((Object)XoaEvent.XoaEventKind.ERROR)) {
                handlerIdToHtml5ObjectMap.remove(handlerId);
            }
        }
    }

    private static String getSchemeAuthority(URI uri) {
        return uri.getScheme() + "_" + uri.getAuthority();
    }

    private static PropertyChangeSupport getCrossOriginProxy(Integer handlerId) {
        Proxy proxy = handlerIdToHtml5ObjectMap.get(handlerId);
        return BridgeUtil.getCrossOriginProxy(proxy);
    }

    private static PropertyChangeSupport getCrossOriginProxy(Proxy proxy) {
        return BridgeUtil.getCrossOriginProxy(proxy.getUri());
    }

    private static PropertyChangeSupport getCrossOriginProxy(URI uri) {
        String schemeAuthority = BridgeUtil.getSchemeAuthority(uri);
        return BridgeUtil.getCrossOriginProxy(schemeAuthority);
    }

    private static PropertyChangeSupport getCrossOriginProxy(String schemeAuthority) {
        return schemeAuthorityToXopMap.get(schemeAuthority);
    }

    private static void initCrossOriginProxy(URI uri) throws Exception {
        LOG.entering(CLASS_NAME, "initCrossOriginProxy", new Object[]{uri});
        PropertyChangeSupport xop = BridgeUtil.getCrossOriginProxy(uri);
        if (xop == null) {
            try {
                String scheme = uri.getScheme();
                String jarUrl = scheme + "://" + uri.getAuthority();
                if (scheme.equals("ws")) {
                    jarUrl = jarUrl.replace("ws:", "http:");
                } else if (scheme.equals("wss")) {
                    jarUrl = jarUrl.replace("wss:", "https:");
                }
                ClassLoaderFactory classLoaderFactory = ClassLoaderFactory.getInstance();
                String jarFileUrl = jarUrl = jarUrl + classLoaderFactory.getQueryParameters();
                LOG.finest("jarFileUrl = " + StringUtils.stripControlCharacters(jarFileUrl));
                ClassLoader loader = classLoaderFactory.createClassLoader(new URL(jarFileUrl), BridgeUtil.class.getClassLoader());
                LOG.finest("Created remote proxy class loader: " + loader);
                Class<?> remoteProxyClass = loader.loadClass(classLoaderFactory.getCrossOriginProxyClass());
                xop = (PropertyChangeSupport)remoteProxyClass.newInstance();
                xop.addPropertyChangeListener(XOP_MESSAGE, evt -> {
                    Object[] args = (Object[])evt.getNewValue();
                    Integer proxyId = (Integer)args[0];
                    String eventType = (String)args[1];
                    Object[] params = (Object[])args[2];
                    BridgeUtil.eventReceived(proxyId, eventType, params);
                });
                schemeAuthorityToXopMap.put(BridgeUtil.getSchemeAuthority(uri), xop);
            }
            catch (Exception e) {
                String reason = "Unable to connect: the Gateway may not be running, a network route may be unavailable, or the Gateway may not be configured properly";
                LOG.log(Level.WARNING, reason);
                LOG.log(Level.FINEST, reason, e);
                throw new Exception(reason);
            }
        }
        LOG.exiting(CLASS_NAME, "initCrossOriginProxy", xop);
    }

    static Proxy createProxy(URI uri, ProxyListener listener) throws Exception {
        LOG.entering(CLASS_NAME, "registerProxy", new Object[0]);
        BridgeUtil.initCrossOriginProxy(uri);
        Integer handlerId = sHtml5ObjectIdCounter.getAndIncrement();
        Proxy proxy = new Proxy();
        proxy.setHandlerId(handlerId);
        proxy.setUri(uri);
        proxy.setListener(listener);
        handlerIdToHtml5ObjectMap.put(handlerId, proxy);
        return proxy;
    }
}

