/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.client.impl.auth;

import java.util.logging.Logger;
import org.kaazing.gateway.client.impl.WebSocketChannel;
import org.kaazing.gateway.client.impl.ws.WebSocketCompositeChannel;
import org.kaazing.net.auth.ChallengeHandler;
import org.kaazing.net.auth.ChallengeRequest;
import org.kaazing.net.auth.ChallengeResponse;

public final class AuthenticationUtil {
    private static final String CLASS_NAME = AuthenticationUtil.class.getName();
    private static final Logger LOG = Logger.getLogger(CLASS_NAME);

    private AuthenticationUtil() {
    }

    public static ChallengeResponse getChallengeResponse(WebSocketChannel channel, ChallengeRequest challengeRequest, ChallengeResponse challengeResponse) {
        LOG.entering(CLASS_NAME, "getChallengeResponse");
        ChallengeHandler challengeHandler = null;
        if (challengeResponse.getNextChallengeHandler() == null) {
            if ((WebSocketCompositeChannel)channel.getParent() != null) {
                challengeHandler = ((WebSocketCompositeChannel)channel.getParent()).getChallengeHandler();
            }
        } else {
            challengeHandler = challengeResponse.getNextChallengeHandler();
        }
        if (challengeHandler == null) {
            throw new IllegalStateException("No challenge handler available for challenge " + challengeRequest);
        }
        try {
            challengeResponse = challengeHandler.handle(challengeRequest);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected error processing challenge: " + challengeRequest, e);
        }
        if (challengeResponse == null) {
            throw new IllegalStateException("Unsupported challenge " + challengeRequest);
        }
        return challengeResponse;
    }
}

