/*
 * Decompiled with CFR 0.152.
 */
package io.particle.android.sdk.cloud;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import io.particle.android.sdk.cloud.ApiDefs;
import io.particle.android.sdk.cloud.ApiFactory;
import io.particle.android.sdk.cloud.ParticleCloud;
import io.particle.android.sdk.cloud.R;
import io.particle.android.sdk.cloud.SDKGlobals;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class SDKProvider {
    private final Context ctx;
    private final ApiDefs.CloudApi cloudApi;
    private final ApiDefs.CloudApi fastTimeoutCloudApi;
    private final ApiDefs.IdentityApi identityApi;
    private final ParticleCloud particleCloud;
    private final TokenGetterDelegateImpl tokenGetter;

    SDKProvider(Context context, @Nullable ApiFactory.OauthBasicAuthCredentialsProvider oAuthCredentialsProvider) {
        this.ctx = context.getApplicationContext();
        if (oAuthCredentialsProvider == null) {
            oAuthCredentialsProvider = new ApiFactory.ResourceValueBasicAuthCredentialsProvider(this.ctx, R.string.oauth_client_id, R.string.oauth_client_secret);
        }
        this.tokenGetter = new TokenGetterDelegateImpl();
        ApiFactory apiFactory = new ApiFactory(this.ctx, this.tokenGetter, oAuthCredentialsProvider);
        this.cloudApi = apiFactory.buildNewCloudApi();
        this.identityApi = apiFactory.buildNewIdentityApi();
        this.fastTimeoutCloudApi = apiFactory.buildNewFastTimeoutCloudApi();
        this.particleCloud = this.buildCloud(apiFactory);
    }

    ApiDefs.CloudApi getCloudApi() {
        return this.cloudApi;
    }

    ApiDefs.IdentityApi getIdentityApi() {
        return this.identityApi;
    }

    ParticleCloud getParticleCloud() {
        return this.particleCloud;
    }

    private ParticleCloud buildCloud(ApiFactory apiFactory) {
        SDKGlobals.init(this.ctx);
        ParticleCloud cloud = new ParticleCloud(apiFactory.getApiUri(), this.cloudApi, this.identityApi, this.fastTimeoutCloudApi, SDKGlobals.getAppDataStorage(), LocalBroadcastManager.getInstance((Context)this.ctx), apiFactory.getGsonInstance(), SDKProvider.buildExecutor());
        this.tokenGetter.cloud = cloud;
        return cloud;
    }

    private static ExecutorService buildExecutor() {
        int CPU_COUNT = Runtime.getRuntime().availableProcessors();
        int CORE_POOL_SIZE = CPU_COUNT + 1;
        int MAXIMUM_POOL_SIZE = CPU_COUNT * 2 + 1;
        int KEEP_ALIVE = 1;
        LinkedBlockingQueue<Runnable> poolWorkQueue = new LinkedBlockingQueue<Runnable>(1024);
        ThreadFactory threadFactory = new ThreadFactory(){
            private final AtomicInteger mCount = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Particle Exec #" + this.mCount.getAndIncrement());
            }
        };
        return new ThreadPoolExecutor(CORE_POOL_SIZE, MAXIMUM_POOL_SIZE, (long)KEEP_ALIVE, TimeUnit.SECONDS, poolWorkQueue, threadFactory);
    }

    private static class TokenGetterDelegateImpl
    implements ApiFactory.TokenGetterDelegate {
        private volatile ParticleCloud cloud;

        private TokenGetterDelegateImpl() {
        }

        @Override
        public String getTokenValue() {
            return this.cloud.getAccessToken();
        }
    }
}

